/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;

public class ChartParam {
    protected String name;
    protected Object value;
    protected String axis;

    public ChartParam() {
    }

    public ChartParam(String name, Object value) {
        this(name, value, null);
    }

    public ChartParam(String name, Object value, String axis) {
        this.name = name;
        this.value = value;
        this.axis = axis;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setAxis(String axis) {
        this.axis = axis;
    }

    public String getAxis() {
        return this.axis;
    }

    public void setPlotString(String plotString) {
        ArgumentTokenizer at = new ArgumentTokenizer(plotString, ':');
        this.name = Escape.removeEscAndQuote(at.next().trim());
        String tmp = at.next();
        if (at.hasNext()) {
            this.axis = Escape.removeEscAndQuote(at.next());
            this.value = "=" + tmp;
        } else {
            boolean removeEscape = !tmp.startsWith("[");
            this.value = Variant.parse(tmp, removeEscape);
            if (this.value instanceof String && Variant.isEquals(tmp, this.value)) {
                this.value = "=" + this.value;
            }
        }
    }

    private String _$1(String val) {
        if (val.startsWith("=")) {
            return val.substring(1);
        }
        Object obj = Variant.parse(val, false);
        if (obj instanceof Number) {
            return val;
        }
        return Escape.addEscAndQuote(val);
    }

    private String _$1(Sequence seq) {
        StringBuffer sb = new StringBuffer("[");
        int size = seq.length();
        for (int i = 1; i <= size; ++i) {
            Object o;
            if (i > 1) {
                sb.append(",");
            }
            if ((o = seq.get(i)) instanceof Sequence) {
                sb.append(this._$1((Sequence)o));
                continue;
            }
            if (o instanceof String) {
                sb.append(this._$1((String)o));
                continue;
            }
            sb.append(Variant.toString(o));
        }
        sb.append("]");
        return sb.toString();
    }

    public String toPlotString(Object defValue) {
        if (this.value == null) {
            return null;
        }
        if (StringUtils.isSpaceString(this.value.toString())) {
            return null;
        }
        if (Variant.isEquals(this.value, defValue)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\"" + this.name + "\":");
        if (this.value instanceof String) {
            String tmp = (String)this.value;
            sb.append(this._$1(tmp));
        } else if (this.value instanceof Sequence) {
            sb.append(this._$1((Sequence)this.value));
        } else {
            sb.append(Variant.toString(this.value));
        }
        if (StringUtils.isValidString(this.axis)) {
            sb.append(":\"" + this.axis + "\"");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (this.value != null) {
            sb.append(":");
            sb.append(this.value);
        }
        if (this.axis != null) {
            sb.append(":");
            sb.append(this.axis);
        }
        return sb.toString();
    }
}

