/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.IComputeItem;
import com.scudata.dm.Sequence;
import com.scudata.expression.Move;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class CurrentElement
extends Node {
    private Sequence _$2;
    private Node _$1;

    public Node getLeft() {
        return this._$1;
    }

    public void setLeft(Node node) {
        this._$1 = node;
    }

    public void setDotLeftObject(Object obj) {
        if (obj instanceof Sequence) {
            this._$2 = (Sequence)obj;
        } else if (obj == null) {
            this._$2 = null;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\".\"" + mm.getMessage("dot.seriesLeft"));
        }
    }

    public void releaseDotLeftObject() {
        this._$2 = null;
    }

    public Object calculate(Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        if (this._$2 == null) {
            return stack.getTopObject().getCurrent();
        }
        return stack.getCurrentValue(this._$2);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        return this.calculateAll(ctx);
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        BoolArray result = leftResult.isTrue();
        IArray array = this.calculateAll(ctx);
        int size = result.size();
        for (int i = 1; i <= size; ++i) {
            if (!result.isTrue(i) || !array.isFalse(i)) continue;
            result.set(i, false);
        }
        return result;
    }

    public IArray calculateAll(Context ctx) {
        if (this._$1 == null) {
            ComputeStack stack = ctx.getComputeStack();
            IComputeItem item = stack.getTopObject();
            Sequence sequence = item.getCurrentSequence();
            if (sequence != null) {
                return sequence.getCurrentMems();
            }
            sequence = stack.getTopSequence();
            Object value = item.getCurrent();
            return new ConstArray(value, sequence.length());
        }
        ComputeStack stack = ctx.getComputeStack();
        Sequence topSequence = stack.getTopSequence();
        IArray leftArray = this._$1.calculateAll(ctx);
        if (leftArray instanceof ConstArray) {
            Object leftValue = ((ConstArray)leftArray).getData();
            if (!(leftValue instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\".\"" + mm.getMessage("dot.seriesLeft"));
            }
            Sequence sequence = (Sequence)leftValue;
            if (topSequence == sequence) {
                return sequence.getCurrentMems();
            }
            Object value = stack.getCurrentValue(sequence);
            return new ConstArray(value, topSequence.length());
        }
        int len = topSequence.length();
        ObjectArray result = new ObjectArray(len);
        result.setTemporary(true);
        for (int i = 1; i <= len; ++i) {
            Object leftValue = leftArray.get(i);
            if (!(leftValue instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\".\"" + mm.getMessage("dot.seriesLeft"));
            }
            Object cur = stack.getCurrentValue((Sequence)leftValue);
            result.push(cur);
        }
        return result;
    }

    public Object assign(Object value, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        if (this._$2 == null) {
            IComputeItem temp = stack.getTopObject();
            if (temp instanceof Current) {
                ((Current)temp).assign(value);
                return value;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.unknownExpression") + "~");
        }
        Current current = stack.getSequenceCurrent(this._$2);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("~" + mm.getMessage("engine.seriesNotInStack"));
        }
        current.assign(value);
        return value;
    }

    public Object addAssign(Object value, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        if (this._$2 == null) {
            IComputeItem temp = stack.getTopObject();
            if (temp instanceof Current) {
                Object result = Variant.add(((Current)temp).getCurrent(), value);
                ((Current)temp).assign(result);
                return result;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.unknownExpression") + "~");
        }
        Current current = stack.getSequenceCurrent(this._$2);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("~" + mm.getMessage("engine.seriesNotInStack"));
        }
        Object result = Variant.add(current.getCurrent(), value);
        current.assign(result);
        return result;
    }

    public Object move(Move node, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        if (this._$2 == null) {
            IComputeItem temp = stack.getTopObject();
            if (temp instanceof Current) {
                Current current = (Current)temp;
                int pos = node.calculateIndex(current, ctx);
                return pos > 0 ? current.get(pos) : null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.unknownExpression") + "~");
        }
        Current current = stack.getSequenceCurrent(this._$2);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"[]\"" + mm.getMessage("engine.seriesNotInStack"));
        }
        int pos = node.calculateIndex(current, ctx);
        return pos > 0 ? current.get(pos) : null;
    }

    public Object moveAssign(Move node, Object value, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        if (this._$2 == null) {
            IComputeItem temp = stack.getTopObject();
            if (temp instanceof Current) {
                Current current = (Current)temp;
                int pos = node.calculateIndex(current, ctx);
                if (pos > 0) {
                    current.assign(pos, value);
                }
                return value;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.unknownExpression") + "~");
        }
        Current current = stack.getSequenceCurrent(this._$2);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"[]\"" + mm.getMessage("engine.seriesNotInStack"));
        }
        int pos = node.calculateIndex(current, ctx);
        if (pos > 0) {
            current.assign(pos, value);
        }
        return value;
    }

    public Object moves(Move node, Context ctx) {
        int startSeq;
        ComputeStack stack = ctx.getComputeStack();
        if (this._$2 == null) {
            IComputeItem temp = stack.getTopObject();
            if (temp instanceof Current) {
                int startSeq2;
                Current current = (Current)temp;
                int[] range = node.calculateIndexRange(current, ctx);
                if (range == null) {
                    return new Sequence(0);
                }
                int endSeq = range[1];
                Sequence result = new Sequence(endSeq - startSeq2 + 1);
                for (startSeq2 = range[0]; startSeq2 <= endSeq; ++startSeq2) {
                    result.add(current.get(startSeq2));
                }
                return result;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.unknownExpression") + "~");
        }
        Current current = stack.getSequenceCurrent(this._$2);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"{}\"" + mm.getMessage("engine.seriesNotInStack"));
        }
        int[] range = node.calculateIndexRange(current, ctx);
        if (range == null) {
            return new Sequence(0);
        }
        int endSeq = range[1];
        Sequence result = new Sequence(endSeq - startSeq + 1);
        for (startSeq = range[0]; startSeq <= endSeq; ++startSeq) {
            result.add(current.get(startSeq));
        }
        return result;
    }

    public boolean isMonotone() {
        return true;
    }
}

