/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.IComputeItem;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.ElementRef;
import com.scudata.expression.Move;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldRef
extends Node {
    protected String name;
    protected Object s2r;
    protected int col;
    protected DataStruct prevDs;
    private Node _$1;

    public FieldRef(String fieldName) {
        this.name = fieldName;
    }

    @Override
    public Node getLeft() {
        return this._$1;
    }

    @Override
    public void setLeft(Node node) {
        this._$1 = node;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void getUsedFields(Context ctx, List<String> resultList) {
        resultList.add(this.name);
    }

    @Override
    public boolean isLeftTypeMatch(Object obj) {
        return true;
    }

    @Override
    public void setDotLeftObject(Object obj) {
        this.s2r = obj;
    }

    @Override
    public void releaseDotLeftObject() {
        this.s2r = null;
    }

    @Override
    public Object calculate(Context ctx) {
        if (this.s2r instanceof Sequence) {
            ComputeStack stack = ctx.getComputeStack();
            Object obj = stack.getCurrentValue((Sequence)this.s2r);
            if (obj instanceof Sequence) {
                if (((Sequence)obj).length() == 0) {
                    return null;
                }
                obj = ((Sequence)obj).get(1);
            }
            if (obj instanceof BaseRecord) {
                BaseRecord cur = (BaseRecord)obj;
                if (this.prevDs != cur.dataStruct()) {
                    this.prevDs = cur.dataStruct();
                    this.col = this.prevDs.getFieldIndex(this.name);
                    if (this.col < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                    }
                }
                return cur.getNormalFieldValue(this.col);
            }
            if (obj == null) {
                if (this.s2r instanceof Table) {
                    this.col = ((Table)this.s2r).dataStruct().getFieldIndex(this.name);
                    if (this.col < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                    }
                }
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
        }
        if (this.s2r instanceof BaseRecord) {
            BaseRecord cur = (BaseRecord)this.s2r;
            if (this.prevDs != cur.dataStruct()) {
                this.prevDs = cur.dataStruct();
                this.col = this.prevDs.getFieldIndex(this.name);
                if (this.col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                }
            }
            return cur.getNormalFieldValue(this.col);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Expression.unknownExpression") + this.name);
    }

    @Override
    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        return this.calculateAll(ctx);
    }

    @Override
    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        BoolArray result = leftResult.isTrue();
        IArray array = this.calculateAll(ctx);
        int size = result.size();
        for (int i = 1; i <= size; ++i) {
            if (!result.isTrue(i) || !array.isFalse(i)) continue;
            result.set(i, false);
        }
        return result;
    }

    private IArray _$1(Object leftObj, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        Sequence top = stack.getTopSequence();
        if (leftObj == top) {
            return top.getFieldValueArray(this.name);
        }
        if (leftObj instanceof Sequence) {
            Sequence sequence = (Sequence)leftObj;
            int n = stack.getCurrentIndex(sequence);
            if (n > 0) {
                leftObj = sequence.getMem(n);
                if (leftObj instanceof Sequence) {
                    leftObj = ((Sequence)leftObj).length() > 0 ? ((Sequence)leftObj).getMem(1) : null;
                }
            } else {
                leftObj = sequence.length() > 0 ? sequence.getMem(1) : null;
            }
            if (leftObj instanceof BaseRecord) {
                BaseRecord r = (BaseRecord)leftObj;
                if (this.prevDs != r.dataStruct()) {
                    this.prevDs = r.dataStruct();
                    this.col = this.prevDs.getFieldIndex(this.name);
                    if (this.col < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                    }
                }
                leftObj = r.getNormalFieldValue(this.col);
            } else if (leftObj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
            }
            return new ConstArray(leftObj, top.length());
        }
        if (leftObj instanceof BaseRecord) {
            BaseRecord r = (BaseRecord)leftObj;
            if (this.prevDs != r.dataStruct()) {
                this.prevDs = r.dataStruct();
                this.col = this.prevDs.getFieldIndex(this.name);
                if (this.col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                }
            }
            return new ConstArray(r.getNormalFieldValue(this.col), top.length());
        }
        if (leftObj == null) {
            return new ConstArray(null, top.length());
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
    }

    @Override
    public IArray calculateAll(Context ctx) {
        if (this._$1 instanceof CurrentElement) {
            ComputeStack stack = ctx.getComputeStack();
            IComputeItem item = stack.getTopObject();
            return item.getCurrentSequence().getFieldValueArray(this.name);
        }
        if (this._$1 instanceof ElementRef) {
            return ((ElementRef)this._$1).getFieldArray(ctx, this);
        }
        IArray leftArray = this._$1.calculateAll(ctx);
        if (leftArray instanceof ConstArray) {
            Object leftObj = leftArray.get(1);
            return this._$1(leftObj, ctx);
        }
        return this.getFieldArray(leftArray);
    }

    public IArray getFieldArray(IArray leftArray) {
        IArray result;
        int len = leftArray.size();
        Object src = leftArray.get(1);
        if (src instanceof BaseRecord) {
            BaseRecord r = (BaseRecord)src;
            if (this.prevDs != r.dataStruct()) {
                this.prevDs = r.dataStruct();
                this.col = this.prevDs.getFieldIndex(this.name);
                if (this.col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                }
            }
            result = r.createFieldValueArray(this.col, len);
        } else {
            result = new ObjectArray(len);
        }
        if (result instanceof ObjectArray) {
            for (int i = 1; i <= len; ++i) {
                src = leftArray.get(i);
                if (src instanceof Sequence) {
                    Sequence seq = (Sequence)src;
                    src = seq.length() > 0 ? seq.getMem(1) : null;
                }
                if (src instanceof BaseRecord) {
                    BaseRecord r = (BaseRecord)src;
                    if (this.prevDs != r.dataStruct()) {
                        this.prevDs = r.dataStruct();
                        this.col = this.prevDs.getFieldIndex(this.name);
                        if (this.col < 0) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                        }
                    }
                    r.getNormalFieldValue(this.col, result);
                    continue;
                }
                if (src == null) {
                    result.push(null);
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                src = leftArray.get(i);
                if (src instanceof BaseRecord) {
                    BaseRecord r = (BaseRecord)src;
                    r.getNormalFieldValue(this.col, result);
                    continue;
                }
                if (src == null) {
                    result.push(null);
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
            }
        }
        result.setTemporary(true);
        return result;
    }

    @Override
    public Object assign(Object value, Context ctx) {
        if (this.s2r instanceof Sequence) {
            ComputeStack stack = ctx.getComputeStack();
            Object obj = stack.getCurrentValue((Sequence)this.s2r);
            if (obj == null) {
                return value;
            }
            if (!(obj instanceof BaseRecord)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
            }
            BaseRecord cur = (BaseRecord)obj;
            if (this.prevDs != cur.dataStruct()) {
                this.prevDs = cur.dataStruct();
                this.col = this.prevDs.getFieldIndex(this.name);
                if (this.col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                }
            }
            cur.setNormalFieldValue(this.col, value);
        } else if (this.s2r instanceof BaseRecord) {
            BaseRecord cur = (BaseRecord)this.s2r;
            if (this.prevDs != cur.dataStruct()) {
                this.prevDs = cur.dataStruct();
                this.col = this.prevDs.getFieldIndex(this.name);
                if (this.col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                }
            }
            cur.setNormalFieldValue(this.col, value);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Expression.unknownExpression") + this.name);
        }
        return value;
    }

    @Override
    public Object addAssign(Object value, Context ctx) {
        if (this.s2r instanceof Sequence) {
            ComputeStack stack = ctx.getComputeStack();
            Object obj = stack.getCurrentValue((Sequence)this.s2r);
            if (obj == null) {
                return value;
            }
            if (!(obj instanceof BaseRecord)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
            }
            BaseRecord cur = (BaseRecord)obj;
            if (this.prevDs != cur.dataStruct()) {
                this.prevDs = cur.dataStruct();
                this.col = this.prevDs.getFieldIndex(this.name);
                if (this.col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                }
            }
            Object result = Variant.add(cur.getNormalFieldValue(this.col), value);
            cur.setNormalFieldValue(this.col, result);
            return result;
        }
        if (this.s2r instanceof BaseRecord) {
            BaseRecord cur = (BaseRecord)this.s2r;
            if (this.prevDs != cur.dataStruct()) {
                this.prevDs = cur.dataStruct();
                this.col = this.prevDs.getFieldIndex(this.name);
                if (this.col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                }
            }
            Object result = Variant.add(cur.getNormalFieldValue(this.col), value);
            cur.setNormalFieldValue(this.col, result);
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Expression.unknownExpression") + this.name);
    }

    @Override
    public Object move(Move node, Context ctx) {
        if (!(this.s2r instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"[]\"" + mm.getMessage("dot.seriesLeft"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = stack.getSequenceCurrent((Sequence)this.s2r);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"[]\"" + mm.getMessage("engine.seriesNotInStack"));
        }
        int pos = node.calculateIndex(current, ctx);
        if (pos < 1) {
            return null;
        }
        Object mem = current.get(pos);
        if (mem == null) {
            return null;
        }
        if (mem instanceof BaseRecord) {
            BaseRecord r = (BaseRecord)mem;
            if (this.prevDs != r.dataStruct()) {
                this.prevDs = r.dataStruct();
                this.col = this.prevDs.getFieldIndex(this.name);
                if (this.col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
                }
            }
            return r.getNormalFieldValue(this.col);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
    }

    @Override
    public Object moveAssign(Move node, Object value, Context ctx) {
        if (!(this.s2r instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"[]\"" + mm.getMessage("dot.seriesLeft"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = stack.getSequenceCurrent((Sequence)this.s2r);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"[]\"" + mm.getMessage("engine.seriesNotInStack"));
        }
        int pos = node.calculateIndex(current, ctx);
        if (pos < 1) {
            return value;
        }
        Object mem = current.get(pos);
        if (mem == null) {
            return value;
        }
        if (!(mem instanceof BaseRecord)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
        }
        BaseRecord r = (BaseRecord)mem;
        if (this.prevDs != r.dataStruct()) {
            this.prevDs = r.dataStruct();
            this.col = this.prevDs.getFieldIndex(this.name);
            if (this.col < 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(this.name + mm.getMessage("ds.fieldNotExist"));
            }
        }
        r.setNormalFieldValue(this.col, value);
        return value;
    }

    @Override
    public Object moves(Move node, Context ctx) {
        if (!(this.s2r instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"[]\"" + mm.getMessage("dot.seriesLeft"));
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = stack.getSequenceCurrent((Sequence)this.s2r);
        if (current == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"[]\"" + mm.getMessage("engine.seriesNotInStack"));
        }
        int[] range = node.calculateIndexRange(current, ctx);
        if (range == null) {
            return new Sequence(0);
        }
        return Move.getFieldValues(current, this.name, range[0], range[1]);
    }

    public int getCol() {
        return this.col;
    }

    @Override
    public boolean isMonotone() {
        return true;
    }
}

