/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.ParamList;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.ParamParser;
import com.scudata.resources.EngineMessage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Function
extends Node {
    protected String functionName;
    protected String option;
    protected String strParam;
    protected IParam param;
    protected ICellSet cs = null;
    protected static final int Default_Size = 4;

    public void setParameter(ICellSet cs, Context ctx, String param) {
        this.strParam = param;
        this.cs = cs;
        this.param = ParamParser.parse(param, cs, ctx);
    }

    public String getParamString() {
        return this.strParam;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String name) {
        this.functionName = name;
    }

    public IParam getParam() {
        return this.param;
    }

    public void setParam(IParam param) {
        this.param = param;
    }

    public void setOption(String opt) {
        this.option = opt;
    }

    public String getOption() {
        return this.option;
    }

    @Override
    protected boolean containParam(String name) {
        if (this.param != null) {
            return this.param.containParam(name);
        }
        return false;
    }

    @Override
    protected void getUsedParams(Context ctx, ParamList resultList) {
        if (this.param != null) {
            this.param.getUsedParams(ctx, resultList);
        }
    }

    @Override
    public void getUsedFields(Context ctx, List<String> resultList) {
        if (this.param != null) {
            this.param.getUsedFields(ctx, resultList);
        }
    }

    @Override
    public void reset() {
        if (this.param != null) {
            this.param.reset();
        }
    }

    @Override
    protected void getUsedCells(List<INormalCell> resultList) {
        if (this.param != null) {
            this.param.getUsedCells(resultList);
        }
    }

    @Override
    public Node optimize(Context ctx) {
        boolean opt = true;
        if (this.param != null) {
            opt = this.param.optimize(ctx);
        }
        if (opt) {
            return new Constant(this.calculate(ctx));
        }
        return this;
    }

    public Expression[] getParamExpressions(String funcName, boolean canNull) {
        Expression[] exps;
        IParam param = this.param;
        if (param == null) {
            if (canNull) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(funcName + mm.getMessage("function.missingParam"));
        }
        if (param.isLeaf()) {
            exps = new Expression[]{param.getLeafExpression()};
        } else {
            int count = param.getSubSize();
            exps = new Expression[count];
            for (int i = 0; i < count; ++i) {
                IParam sub = param.getSub(i);
                if (sub != null) {
                    exps[i] = sub.getLeafExpression();
                    continue;
                }
                if (canNull) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException(funcName + mm.getMessage("function.invalidParam"));
            }
        }
        return exps;
    }

    public String getFunctionString() {
        String strRes = this.getFunctionName();
        if (null != this.option && 0 != this.option.length()) {
            strRes = strRes + "@" + this.option;
        }
        strRes = strRes + "(";
        strRes = strRes + this.strParam;
        strRes = strRes + ")";
        return strRes;
    }

    @Override
    public boolean isFunction(String name) {
        return name.equals(this.functionName);
    }

    @Override
    public boolean canCalculateAll() {
        if (this.param != null) {
            return this.param.canCalculateAll();
        }
        return true;
    }

    public ICellSet getCellSet() {
        return this.cs;
    }
}

