/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DfxManager;
import com.scudata.expression.Constant;
import com.scudata.expression.DfxFunction;
import com.scudata.expression.Function;
import com.scudata.expression.MemberFunction;
import com.scudata.expression.lllIlIlIIIIlllll;
import com.scudata.expression.operator.DotOperator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Properties;
import com.scudata.util.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionLib {
    private static HashMap<String, Class<? extends Function>> _$3 = new HashMap(256);
    private static HashMap<String, lllIlIlIIIIlllll> _$2 = new HashMap(256);
    private static HashMap<String, DfxFunction> _$1 = new HashMap(256);

    private FunctionLib() {
    }

    public static void addFunction(String fnName, String className) {
        try {
            Class<?> funClass = Class.forName(className);
            if (_$3.containsKey(fnName)) {
                MessageManager mm = EngineMessage.get();
                throw new RuntimeException(mm.getMessage("FunctionLib.repeatedFunction") + fnName);
            }
            _$3.put(fnName, funClass);
        }
        catch (Throwable e) {
            throw new RQException(className, e);
        }
    }

    public static void addFunction(String fnName, Class<? extends Function> funClass) {
        if (_$3.containsKey(fnName)) {
            MessageManager mm = EngineMessage.get();
            throw new RuntimeException(mm.getMessage("FunctionLib.repeatedFunction") + fnName);
        }
        _$3.put(fnName, funClass);
    }

    public static void addFunction(String fnName, String className, boolean replace) {
        if (replace || !_$3.containsKey(fnName)) {
            try {
                Class<?> funClass = Class.forName(className);
                _$3.put(fnName, funClass);
            }
            catch (Throwable e) {
                throw new RQException(className, e);
            }
        }
    }

    public static boolean isFnName(String id) {
        return _$3.containsKey(id);
    }

    public static Function newFunction(String fnName) {
        try {
            Class<? extends Function> funClass = _$3.get(fnName);
            Function function = funClass.newInstance();
            function.setFunctionName(fnName);
            return function;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void addMemberFunction(String fnName, String className) {
        try {
            Class<?> fnClass = Class.forName(className);
            FunctionLib.addMemberFunction(fnName, fnClass);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void addMemberFunction(String fnName, Class<? extends MemberFunction> fnClass) {
        lllIlIlIIIIlllll prev = _$2.get(fnName);
        lllIlIlIIIIlllll fnLink = new lllIlIlIIIIlllll(fnClass);
        if (prev == null) {
            _$2.put(fnName, fnLink);
        } else {
            while (prev._$1 != null) {
                prev = prev._$1;
            }
            prev._$1 = fnLink;
        }
    }

    public static boolean isMemberFnName(String id) {
        return _$2.containsKey(id);
    }

    public static MemberFunction newMemberFunction(String fnName) {
        try {
            lllIlIlIIIIlllll fnLink = _$2.get(fnName);
            return fnLink._$1(fnName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static void _$1() {
        FunctionLib.addFunction("between", "com.scudata.expression.fn.Between");
        FunctionLib.addFunction("case", "com.scudata.expression.fn.Case");
        FunctionLib.addFunction("cmp", "com.scudata.expression.fn.Compare");
        FunctionLib.addFunction("cmps", "com.scudata.expression.fn.Compares");
        FunctionLib.addFunction("clipboard", "com.scudata.expression.fn.Clipboard");
        FunctionLib.addFunction("eval", "com.scudata.expression.fn.Eval");
        FunctionLib.addFunction("if", "com.scudata.expression.fn.If");
        FunctionLib.addFunction("to", "com.scudata.expression.fn.To");
        FunctionLib.addFunction("join", "com.scudata.expression.fn.Join");
        FunctionLib.addFunction("xjoin", "com.scudata.expression.fn.XJoin");
        FunctionLib.addFunction("create", "com.scudata.expression.fn.Create");
        FunctionLib.addFunction("new", "com.scudata.expression.fn.New");
        FunctionLib.addFunction("sum", "com.scudata.expression.fn.gather.Sum");
        FunctionLib.addFunction("avg", "com.scudata.expression.fn.gather.Average");
        FunctionLib.addFunction("max", "com.scudata.expression.fn.gather.Max");
        FunctionLib.addFunction("min", "com.scudata.expression.fn.gather.Min");
        FunctionLib.addFunction("maxp", "com.scudata.expression.fn.gather.Maxp");
        FunctionLib.addFunction("minp", "com.scudata.expression.fn.gather.Minp");
        FunctionLib.addFunction("conj", "com.scudata.expression.fn.gather.Conj");
        FunctionLib.addFunction("union", "com.scudata.expression.fn.gather.Union");
        FunctionLib.addFunction("cand", "com.scudata.expression.fn.Cand");
        FunctionLib.addFunction("cor", "com.scudata.expression.fn.Cor");
        FunctionLib.addFunction("top", "com.scudata.expression.fn.gather.Top");
        FunctionLib.addFunction("ifn", "com.scudata.expression.fn.Ifn");
        FunctionLib.addFunction("nvl", "com.scudata.expression.fn.Nvl");
        FunctionLib.addFunction("count", "com.scudata.expression.fn.gather.Count");
        FunctionLib.addFunction("func", "com.scudata.expression.fn.Func");
        FunctionLib.addFunction("call", "com.scudata.expression.fn.Call");
        FunctionLib.addFunction("register", "com.scudata.expression.fn.Register");
        FunctionLib.addFunction("arguments", "com.scudata.expression.fn.Arguments");
        FunctionLib.addFunction("env", "com.scudata.expression.fn.EnvSet");
        FunctionLib.addFunction("system", "com.scudata.expression.fn.SystemExec");
        FunctionLib.addFunction("output", "com.scudata.expression.fn.Output");
        FunctionLib.addFunction("jvm", "com.scudata.expression.fn.JVM");
        FunctionLib.addFunction("sleep", "com.scudata.expression.fn.Sleep");
        FunctionLib.addFunction("lock", "com.scudata.expression.fn.Lock");
        FunctionLib.addFunction("invoke", "com.scudata.expression.fn.Invoke");
        FunctionLib.addFunction("icount", "com.scudata.expression.fn.gather.ICount");
        FunctionLib.addFunction("mode", "com.scudata.expression.fn.Mode");
        FunctionLib.addFunction("median", "com.scudata.expression.fn.gather.Median");
        FunctionLib.addFunction("z", "com.scudata.expression.fn.ZSeq");
        FunctionLib.addFunction("ntile", "com.scudata.expression.fn.Ntile");
        FunctionLib.addFunction("iterate", "com.scudata.expression.fn.gather.Iterate");
        FunctionLib.addFunction("seq", "com.scudata.expression.fn.Seq");
        FunctionLib.addFunction("rank", "com.scudata.expression.fn.Rank");
        FunctionLib.addFunction("ranki", "com.scudata.expression.fn.Ranki");
        FunctionLib.addFunction("cum", "com.scudata.expression.fn.Cum");
        FunctionLib.addFunction("get", "com.scudata.expression.fn.Get");
        FunctionLib.addFunction("k", "com.scudata.expression.fn.CreateSerialBytes");
        FunctionLib.addFunction("range", "com.scudata.expression.fn.Range");
        FunctionLib.addFunction("blob", "com.scudata.expression.fn.Blob");
        FunctionLib.addFunction("jdbccall", "com.scudata.expression.fn.JDBCCall");
        FunctionLib.addMemberFunction("step", "com.scudata.expression.mfn.sequence.Step");
        FunctionLib.addMemberFunction("inv", "com.scudata.expression.mfn.sequence.Inv");
        FunctionLib.addMemberFunction("p", "com.scudata.expression.mfn.sequence.PosConvert");
        FunctionLib.addMemberFunction("m", "com.scudata.expression.mfn.sequence.MGet");
        FunctionLib.addMemberFunction("eq", "com.scudata.expression.mfn.sequence.Eq");
        FunctionLib.addMemberFunction("count", "com.scudata.expression.mfn.sequence.Count");
        FunctionLib.addMemberFunction("len", "com.scudata.expression.mfn.sequence.Len");
        FunctionLib.addMemberFunction("sbs", "com.scudata.expression.mfn.serial.Sbs");
        FunctionLib.addMemberFunction("ifn", "com.scudata.expression.mfn.sequence.Ifn");
        FunctionLib.addMemberFunction("nvl", "com.scudata.expression.mfn.sequence.Nvl");
        FunctionLib.addMemberFunction("id", "com.scudata.expression.mfn.sequence.Id");
        FunctionLib.addMemberFunction("id", "com.scudata.expression.mfn.cursor.Id");
        FunctionLib.addMemberFunction("id", "com.scudata.expression.mfn.channel.Id");
        FunctionLib.addMemberFunction("sum", "com.scudata.expression.mfn.sequence.Sum");
        FunctionLib.addMemberFunction("cumulate", "com.scudata.expression.mfn.sequence.Cumulate");
        FunctionLib.addMemberFunction("proportion", "com.scudata.expression.mfn.sequence.Proportion");
        FunctionLib.addMemberFunction("icount", "com.scudata.expression.mfn.sequence.ICount");
        FunctionLib.addMemberFunction("mode", "com.scudata.expression.mfn.sequence.Mode");
        FunctionLib.addMemberFunction("avg", "com.scudata.expression.mfn.sequence.Avg");
        FunctionLib.addMemberFunction("min", "com.scudata.expression.mfn.sequence.Min");
        FunctionLib.addMemberFunction("max", "com.scudata.expression.mfn.sequence.Max");
        FunctionLib.addMemberFunction("minp", "com.scudata.expression.mfn.sequence.Minp");
        FunctionLib.addMemberFunction("maxp", "com.scudata.expression.mfn.sequence.Maxp");
        FunctionLib.addMemberFunction("cand", "com.scudata.expression.mfn.sequence.Cand");
        FunctionLib.addMemberFunction("cor", "com.scudata.expression.mfn.sequence.Cor");
        FunctionLib.addMemberFunction("rank", "com.scudata.expression.mfn.sequence.Rank");
        FunctionLib.addMemberFunction("ranks", "com.scudata.expression.mfn.sequence.Ranks");
        FunctionLib.addMemberFunction("conj", "com.scudata.expression.mfn.sequence.Conj");
        FunctionLib.addMemberFunction("conj", "com.scudata.expression.mfn.op.AttachConj");
        FunctionLib.addMemberFunction("union", "com.scudata.expression.mfn.sequence.Union");
        FunctionLib.addMemberFunction("diff", "com.scudata.expression.mfn.sequence.Diff");
        FunctionLib.addMemberFunction("isect", "com.scudata.expression.mfn.sequence.Isect");
        FunctionLib.addMemberFunction("xunion", "com.scudata.expression.mfn.sequence.Xunion");
        FunctionLib.addMemberFunction("merge", "com.scudata.expression.mfn.sequence.Merge");
        FunctionLib.addMemberFunction("run", "com.scudata.expression.mfn.sequence.Run");
        FunctionLib.addMemberFunction("run", "com.scudata.expression.mfn.op.AttachRun");
        FunctionLib.addMemberFunction("run", "com.scudata.expression.mfn.record.Run");
        FunctionLib.addMemberFunction("calc", "com.scudata.expression.mfn.sequence.Calc");
        FunctionLib.addMemberFunction("pos", "com.scudata.expression.mfn.sequence.Pos");
        FunctionLib.addMemberFunction("contain", "com.scudata.expression.mfn.sequence.Contain");
        FunctionLib.addMemberFunction("pseg", "com.scudata.expression.mfn.sequence.PSeg");
        FunctionLib.addMemberFunction("segp", "com.scudata.expression.mfn.sequence.Segp");
        FunctionLib.addMemberFunction("pmin", "com.scudata.expression.mfn.sequence.PMin");
        FunctionLib.addMemberFunction("pmax", "com.scudata.expression.mfn.sequence.PMax");
        FunctionLib.addMemberFunction("ptop", "com.scudata.expression.mfn.sequence.PTop");
        FunctionLib.addMemberFunction("top", "com.scudata.expression.mfn.sequence.Top");
        FunctionLib.addMemberFunction("pselect", "com.scudata.expression.mfn.sequence.PSelect");
        FunctionLib.addMemberFunction("psort", "com.scudata.expression.mfn.sequence.PSort");
        FunctionLib.addMemberFunction("select", "com.scudata.expression.mfn.sequence.Select");
        FunctionLib.addMemberFunction("select", "com.scudata.expression.mfn.op.AttachSelect");
        FunctionLib.addMemberFunction("sort", "com.scudata.expression.mfn.sequence.Sort");
        FunctionLib.addMemberFunction("rvs", "com.scudata.expression.mfn.sequence.Rvs");
        FunctionLib.addMemberFunction("swap", "com.scudata.expression.mfn.sequence.Swap");
        FunctionLib.addMemberFunction("shift", "com.scudata.expression.mfn.sequence.Shift");
        FunctionLib.addMemberFunction("pad", "com.scudata.expression.mfn.sequence.Pad");
        FunctionLib.addMemberFunction("lookup", "com.scudata.expression.mfn.sequence.Lookup");
        FunctionLib.addMemberFunction("sumif", "com.scudata.expression.mfn.sequence.Sumif");
        FunctionLib.addMemberFunction("countif", "com.scudata.expression.mfn.sequence.Countif");
        FunctionLib.addMemberFunction("avgif", "com.scudata.expression.mfn.sequence.Avgif");
        FunctionLib.addMemberFunction("minif", "com.scudata.expression.mfn.sequence.Minif");
        FunctionLib.addMemberFunction("maxif", "com.scudata.expression.mfn.sequence.Maxif");
        FunctionLib.addMemberFunction("iterate", "com.scudata.expression.mfn.sequence.Iterate");
        FunctionLib.addMemberFunction("iterate", "com.scudata.expression.mfn.cursor.Iterate");
        FunctionLib.addMemberFunction("iterate", "com.scudata.expression.mfn.channel.Iterate");
        FunctionLib.addMemberFunction("fno", "com.scudata.expression.mfn.record.FieldNo");
        FunctionLib.addMemberFunction("fno", "com.scudata.expression.mfn.sequence.FieldNo");
        FunctionLib.addMemberFunction("field", "com.scudata.expression.mfn.record.FieldValue");
        FunctionLib.addMemberFunction("field", "com.scudata.expression.mfn.sequence.FieldValue");
        FunctionLib.addMemberFunction("fname", "com.scudata.expression.mfn.record.FieldName");
        FunctionLib.addMemberFunction("fname", "com.scudata.expression.mfn.sequence.FieldName");
        FunctionLib.addMemberFunction("to", "com.scudata.expression.mfn.sequence.To");
        FunctionLib.addMemberFunction("range", "com.scudata.expression.mfn.sequence.Range");
        FunctionLib.addMemberFunction("pivot", "com.scudata.expression.mfn.sequence.Pivot");
        FunctionLib.addMemberFunction("groupc", "com.scudata.expression.mfn.sequence.Groupc");
        FunctionLib.addMemberFunction("r", "com.scudata.expression.mfn.RowField");
        FunctionLib.addMemberFunction("median", "com.scudata.expression.mfn.sequence.Median");
        FunctionLib.addMemberFunction("bits", "com.scudata.expression.mfn.sequence.Bits");
        FunctionLib.addMemberFunction("icursor", "com.scudata.expression.mfn.table.Icursor");
        FunctionLib.addMemberFunction("ifind", "com.scudata.expression.mfn.table.Ifind");
        FunctionLib.addMemberFunction("memory", "com.scudata.expression.mfn.table.Memory");
        FunctionLib.addMemberFunction("modify", "com.scudata.expression.mfn.sequence.Modify");
        FunctionLib.addMemberFunction("modify", "com.scudata.expression.mfn.record.Modify");
        FunctionLib.addMemberFunction("reset", "com.scudata.expression.mfn.sequence.Reset");
        FunctionLib.addMemberFunction("reset", "com.scudata.expression.mfn.cursor.Reset");
        FunctionLib.addMemberFunction("insert", "com.scudata.expression.mfn.sequence.Insert");
        FunctionLib.addMemberFunction("delete", "com.scudata.expression.mfn.sequence.Delete");
        FunctionLib.addMemberFunction("paste", "com.scudata.expression.mfn.table.Paste");
        FunctionLib.addMemberFunction("record", "com.scudata.expression.mfn.sequence.RecordValue");
        FunctionLib.addMemberFunction("record", "com.scudata.expression.mfn.record.RecordValue");
        FunctionLib.addMemberFunction("rename", "com.scudata.expression.mfn.table.Rename");
        FunctionLib.addMemberFunction("rename", "com.scudata.expression.mfn.op.AttachRename");
        FunctionLib.addMemberFunction("rename", "com.scudata.expression.mfn.vdb.Rename");
        FunctionLib.addMemberFunction("alter", "com.scudata.expression.mfn.table.Alter");
        FunctionLib.addMemberFunction("alter", "com.scudata.expression.mfn.record.Alter");
        FunctionLib.addMemberFunction("create", "com.scudata.expression.mfn.sequence.Create");
        FunctionLib.addMemberFunction("create", "com.scudata.expression.mfn.record.Create");
        FunctionLib.addMemberFunction("new", "com.scudata.expression.mfn.sequence.New");
        FunctionLib.addMemberFunction("new", "com.scudata.expression.mfn.op.AttachNew");
        FunctionLib.addMemberFunction("derive", "com.scudata.expression.mfn.sequence.Derive");
        FunctionLib.addMemberFunction("derive", "com.scudata.expression.mfn.op.AttachDerive");
        FunctionLib.addMemberFunction("derive", "com.scudata.expression.mfn.record.Derive");
        FunctionLib.addMemberFunction("penum", "com.scudata.expression.mfn.sequence.PEnum");
        FunctionLib.addMemberFunction("align", "com.scudata.expression.mfn.sequence.Align");
        FunctionLib.addMemberFunction("enum", "com.scudata.expression.mfn.sequence.Enum");
        FunctionLib.addMemberFunction("group", "com.scudata.expression.mfn.sequence.Group");
        FunctionLib.addMemberFunction("group", "com.scudata.expression.mfn.op.AttachGroup");
        FunctionLib.addMemberFunction("groups", "com.scudata.expression.mfn.sequence.Groups");
        FunctionLib.addMemberFunction("groups", "com.scudata.expression.mfn.cursor.Groups");
        FunctionLib.addMemberFunction("groups", "com.scudata.expression.mfn.channel.Groups");
        FunctionLib.addMemberFunction("groupi", "com.scudata.expression.mfn.sequence.Groupi");
        FunctionLib.addMemberFunction("news", "com.scudata.expression.mfn.sequence.News");
        FunctionLib.addMemberFunction("news", "com.scudata.expression.mfn.op.AttachNews");
        FunctionLib.addMemberFunction("pfind", "com.scudata.expression.mfn.sequence.PFind");
        FunctionLib.addMemberFunction("find", "com.scudata.expression.mfn.sequence.Find");
        FunctionLib.addMemberFunction("v", "com.scudata.expression.mfn.Value");
        FunctionLib.addMemberFunction("key", "com.scudata.expression.mfn.record.Key");
        FunctionLib.addMemberFunction("keys", "com.scudata.expression.mfn.table.Keys");
        FunctionLib.addMemberFunction("switch", "com.scudata.expression.mfn.sequence.SwitchFK");
        FunctionLib.addMemberFunction("switch", "com.scudata.expression.mfn.op.AttachSwitch");
        FunctionLib.addMemberFunction("index", "com.scudata.expression.mfn.table.Index");
        FunctionLib.addMemberFunction("prior", "com.scudata.expression.mfn.record.Prior");
        FunctionLib.addMemberFunction("nodes", "com.scudata.expression.mfn.sequence.Nodes");
        FunctionLib.addMemberFunction("nodes", "com.scudata.expression.mfn.Nodes");
        FunctionLib.addMemberFunction("array", "com.scudata.expression.mfn.record.Array");
        FunctionLib.addMemberFunction("array", "com.scudata.expression.mfn.sequence.Array");
        FunctionLib.addMemberFunction("regex", "com.scudata.expression.mfn.string.Regex");
        FunctionLib.addMemberFunction("regex", "com.scudata.expression.mfn.sequence.Regex");
        FunctionLib.addMemberFunction("regex", "com.scudata.expression.mfn.op.AttachRegex");
        FunctionLib.addMemberFunction("concat", "com.scudata.expression.mfn.sequence.Concat");
        FunctionLib.addFunction("filename", "com.scudata.expression.fn.FileName");
        FunctionLib.addFunction("directory", "com.scudata.expression.fn.Directory");
        FunctionLib.addFunction("file", "com.scudata.expression.fn.CreateFile");
        FunctionLib.addFunction("movefile", "com.scudata.expression.fn.MoveFile");
        FunctionLib.addFunction("httpfile", "com.scudata.expression.fn.CreateHttpFile");
        FunctionLib.addFunction("httpupload", "com.scudata.expression.fn.Http_Upload");
        FunctionLib.addMemberFunction("read", "com.scudata.expression.mfn.file.Read");
        FunctionLib.addMemberFunction("write", "com.scudata.expression.mfn.file.Write");
        FunctionLib.addMemberFunction("export", "com.scudata.expression.mfn.file.Export");
        FunctionLib.addMemberFunction("export", "com.scudata.expression.mfn.sequence.Export");
        FunctionLib.addMemberFunction("import", "com.scudata.expression.mfn.file.Import");
        FunctionLib.addMemberFunction("import", "com.scudata.expression.mfn.string.Import");
        FunctionLib.addMemberFunction("name", "com.scudata.expression.mfn.file.Name");
        FunctionLib.addMemberFunction("exists", "com.scudata.expression.mfn.file.Exists");
        FunctionLib.addMemberFunction("size", "com.scudata.expression.mfn.file.Size");
        FunctionLib.addMemberFunction("date", "com.scudata.expression.mfn.file.Date");
        FunctionLib.addMemberFunction("property", "com.scudata.expression.mfn.file.Property");
        FunctionLib.addMemberFunction("property", "com.scudata.expression.mfn.string.Property");
        FunctionLib.addMemberFunction("iselect", "com.scudata.expression.mfn.file.ISelect");
        FunctionLib.addMemberFunction("xlsexport", "com.scudata.expression.mfn.file.XlsExport");
        FunctionLib.addMemberFunction("xlsexport", "com.scudata.expression.mfn.xo.XlsExport");
        FunctionLib.addMemberFunction("xlsimport", "com.scudata.expression.mfn.file.XlsImport");
        FunctionLib.addMemberFunction("xlsimport", "com.scudata.expression.mfn.xo.XlsImport");
        FunctionLib.addMemberFunction("xlsopen", "com.scudata.expression.mfn.file.XlsOpen");
        FunctionLib.addMemberFunction("xlswrite", "com.scudata.expression.mfn.file.XlsWrite");
        FunctionLib.addMemberFunction("xlsclose", "com.scudata.expression.mfn.xo.XlsClose");
        FunctionLib.addMemberFunction("xlscell", "com.scudata.expression.mfn.xo.XlsCell");
        FunctionLib.addMemberFunction("xlsmove", "com.scudata.expression.mfn.xo.XlsMove");
        FunctionLib.addFunction("T", "com.scudata.expression.fn.T");
        FunctionLib.addFunction("E", "com.scudata.expression.fn.E");
        FunctionLib.addFunction("chardetect", "com.scudata.expression.fn.CharDetect");
        FunctionLib.addFunction("cellname", "com.scudata.expression.fn.CellName");
        FunctionLib.addMemberFunction("htmlparse", "com.scudata.expression.mfn.string.HTMLParse");
        FunctionLib.addMemberFunction("close", "com.scudata.expression.mfn.Close");
        FunctionLib.addFunction("connect", "com.scudata.expression.fn.Connect");
        FunctionLib.addMemberFunction("commit", "com.scudata.expression.mfn.db.Commit");
        FunctionLib.addMemberFunction("rollback", "com.scudata.expression.mfn.db.Rollback");
        FunctionLib.addMemberFunction("rollback", "com.scudata.expression.mfn.file.Rollback");
        FunctionLib.addMemberFunction("rollback", "com.scudata.expression.mfn.file.FileGroupRollback");
        FunctionLib.addMemberFunction("query", "com.scudata.expression.mfn.db.Query");
        FunctionLib.addMemberFunction("query", "com.scudata.expression.mfn.file.Query");
        FunctionLib.addMemberFunction("execute", "com.scudata.expression.mfn.db.Execute");
        FunctionLib.addMemberFunction("proc", "com.scudata.expression.mfn.db.Proc");
        FunctionLib.addMemberFunction("error", "com.scudata.expression.mfn.db.Error");
        FunctionLib.addMemberFunction("update", "com.scudata.expression.mfn.db.Update");
        FunctionLib.addMemberFunction("isolate", "com.scudata.expression.mfn.db.Isolate");
        FunctionLib.addMemberFunction("savepoint", "com.scudata.expression.mfn.db.SavePoint");
        FunctionLib.addFunction("vdbase", "com.scudata.expression.fn.VDBase");
        FunctionLib.addMemberFunction("begin", "com.scudata.expression.mfn.vdb.Begin");
        FunctionLib.addMemberFunction("commit", "com.scudata.expression.mfn.vdb.Commit");
        FunctionLib.addMemberFunction("rollback", "com.scudata.expression.mfn.vdb.Rollback");
        FunctionLib.addMemberFunction("home", "com.scudata.expression.mfn.vdb.Home");
        FunctionLib.addMemberFunction("path", "com.scudata.expression.mfn.vdb.Path");
        FunctionLib.addMemberFunction("lock", "com.scudata.expression.mfn.vdb.Lock");
        FunctionLib.addMemberFunction("list", "com.scudata.expression.mfn.vdb.List");
        FunctionLib.addMemberFunction("load", "com.scudata.expression.mfn.vdb.Load");
        FunctionLib.addMemberFunction("date", "com.scudata.expression.mfn.vdb.Date");
        FunctionLib.addMemberFunction("save", "com.scudata.expression.mfn.vdb.Save");
        FunctionLib.addMemberFunction("move", "com.scudata.expression.mfn.vdb.Move");
        FunctionLib.addMemberFunction("read", "com.scudata.expression.mfn.vdb.Read");
        FunctionLib.addMemberFunction("write", "com.scudata.expression.mfn.vdb.Write");
        FunctionLib.addMemberFunction("update", "com.scudata.expression.mfn.vdb.Update");
        FunctionLib.addMemberFunction("saveblob", "com.scudata.expression.mfn.vdb.SaveBlob");
        FunctionLib.addMemberFunction("retrieve", "com.scudata.expression.mfn.vdb.Retrive");
        FunctionLib.addMemberFunction("archive", "com.scudata.expression.mfn.vdb.Archive");
        FunctionLib.addMemberFunction("purge", "com.scudata.expression.mfn.vdb.Purge");
        FunctionLib.addMemberFunction("copy", "com.scudata.expression.mfn.vdb.Copy");
        FunctionLib.addMemberFunction("cursor", "com.scudata.expression.mfn.db.CreateCursor");
        FunctionLib.addMemberFunction("cursor", "com.scudata.expression.mfn.file.CreateCursor");
        FunctionLib.addMemberFunction("cursor", "com.scudata.expression.mfn.sequence.CreateCursor");
        FunctionLib.addMemberFunction("cursor", "com.scudata.expression.mfn.cursor.CreateCursor");
        FunctionLib.addMemberFunction("mcursor", "com.scudata.expression.mfn.sequence.MCursor");
        FunctionLib.addMemberFunction("mcursor", "com.scudata.expression.mfn.cursor.MCursor");
        FunctionLib.addMemberFunction("fetch", "com.scudata.expression.mfn.cursor.Fetch");
        FunctionLib.addMemberFunction("fetch", "com.scudata.expression.mfn.channel.Fetch");
        FunctionLib.addMemberFunction("skip", "com.scudata.expression.mfn.cursor.Skip");
        FunctionLib.addMemberFunction("groupx", "com.scudata.expression.mfn.cursor.Groupx");
        FunctionLib.addMemberFunction("groupx", "com.scudata.expression.mfn.channel.Groupx");
        FunctionLib.addMemberFunction("groupn", "com.scudata.expression.mfn.op.AttachGroupn");
        FunctionLib.addMemberFunction("sortx", "com.scudata.expression.mfn.cursor.Sortx");
        FunctionLib.addMemberFunction("sortx", "com.scudata.expression.mfn.channel.Sortx");
        FunctionLib.addMemberFunction("join", "com.scudata.expression.mfn.op.AttachJoin");
        FunctionLib.addMemberFunction("join", "com.scudata.expression.mfn.sequence.JoinFK");
        FunctionLib.addMemberFunction("fjoin", "com.scudata.expression.mfn.sequence.FJoin");
        FunctionLib.addMemberFunction("fjoin", "com.scudata.expression.mfn.op.AttachFJoin");
        FunctionLib.addMemberFunction("pjoin", "com.scudata.expression.mfn.sequence.PJoin");
        FunctionLib.addMemberFunction("pjoin", "com.scudata.expression.mfn.op.AttachPJoin");
        FunctionLib.addMemberFunction("mjoin", "com.scudata.expression.mfn.sequence.MJoin");
        FunctionLib.addMemberFunction("joinx", "com.scudata.expression.mfn.cursor.Joinx");
        FunctionLib.addMemberFunction("joinx", "com.scudata.expression.mfn.sequence.Joinx");
        FunctionLib.addMemberFunction("joinx", "com.scudata.expression.mfn.channel.Joinx");
        FunctionLib.addMemberFunction("mergex", "com.scudata.expression.mfn.cursor.Mergex");
        FunctionLib.addMemberFunction("mergex", "com.scudata.expression.mfn.sequence.Mergex");
        FunctionLib.addMemberFunction("conjx", "com.scudata.expression.mfn.sequence.Conjx");
        FunctionLib.addMemberFunction("total", "com.scudata.expression.mfn.cursor.Total");
        FunctionLib.addMemberFunction("total", "com.scudata.expression.mfn.channel.Total");
        FunctionLib.addFunction("xjoinx", "com.scudata.expression.fn.XJoinx");
        FunctionLib.addFunction("joinx", "com.scudata.expression.fn.Joinx");
        FunctionLib.addFunction("cursor", "com.scudata.expression.fn.CreateCursor");
        FunctionLib.addFunction("channel", "com.scudata.expression.fn.CreateChannel");
        FunctionLib.addMemberFunction("push", "com.scudata.expression.mfn.op.AttachPush");
        FunctionLib.addMemberFunction("result", "com.scudata.expression.mfn.channel.Result");
        FunctionLib.addMemberFunction("row", "com.scudata.expression.mfn.TableRow");
        FunctionLib.addMemberFunction("attach", "com.scudata.expression.mfn.dw.Attach");
        FunctionLib.addMemberFunction("append", "com.scudata.expression.mfn.dw.Append");
        FunctionLib.addMemberFunction("update", "com.scudata.expression.mfn.dw.Update");
        FunctionLib.addMemberFunction("update", "com.scudata.expression.mfn.dw.UpdateMemoryTable");
        FunctionLib.addMemberFunction("delete", "com.scudata.expression.mfn.dw.Delete");
        FunctionLib.addMemberFunction("index", "com.scudata.expression.mfn.dw.Index");
        FunctionLib.addMemberFunction("memory", "com.scudata.expression.mfn.dw.Memory");
        FunctionLib.addMemberFunction("cursor", "com.scudata.expression.mfn.dw.CreateCursor");
        FunctionLib.addMemberFunction("import", "com.scudata.expression.mfn.dw.Import");
        FunctionLib.addMemberFunction("new", "com.scudata.expression.mfn.dw.New");
        FunctionLib.addMemberFunction("news", "com.scudata.expression.mfn.dw.News");
        FunctionLib.addMemberFunction("derive", "com.scudata.expression.mfn.dw.Derive");
        FunctionLib.addMemberFunction("icursor", "com.scudata.expression.mfn.dw.Icursor");
        FunctionLib.addMemberFunction("cgroups", "com.scudata.expression.mfn.dw.Cgroups");
        FunctionLib.addMemberFunction("find", "com.scudata.expression.mfn.dw.Find");
        FunctionLib.addMemberFunction("create", "com.scudata.expression.mfn.file.Create");
        FunctionLib.addMemberFunction("create", "com.scudata.expression.mfn.dw.Create");
        FunctionLib.addMemberFunction("open", "com.scudata.expression.mfn.file.Open");
        FunctionLib.addMemberFunction("reset", "com.scudata.expression.mfn.file.Reset");
        FunctionLib.addMemberFunction("create", "com.scudata.expression.mfn.file.FileGroupCreate");
        FunctionLib.addMemberFunction("reset", "com.scudata.expression.mfn.file.FileGroupReset");
        FunctionLib.addMemberFunction("open", "com.scudata.expression.mfn.file.FileGroupOpen");
        FunctionLib.addMemberFunction("cuboid", "com.scudata.expression.mfn.dw.CreateCuboid");
        FunctionLib.addMemberFunction("rename", "com.scudata.expression.mfn.dw.Rename");
        FunctionLib.addMemberFunction("alter", "com.scudata.expression.mfn.dw.Alter");
        FunctionLib.addMemberFunction("structure", "com.scudata.expression.mfn.file.Structure");
        FunctionLib.addMemberFunction("structure", "com.scudata.expression.mfn.file.FileGroupStructure");
        FunctionLib.addMemberFunction("memory", "com.scudata.expression.mfn.cursor.Memory");
        FunctionLib.addMemberFunction("dup", "com.scudata.expression.mfn.table.Dup");
        FunctionLib.addFunction("canvas", "com.scudata.expression.fn.CreateCanvas");
        FunctionLib.addMemberFunction("plot", "com.scudata.expression.mfn.canvas.Plot");
        FunctionLib.addMemberFunction("draw", "com.scudata.expression.mfn.canvas.Draw");
        FunctionLib.addMemberFunction("hlink", "com.scudata.expression.mfn.canvas.HLink");
        FunctionLib.addFunction("age", "com.scudata.expression.fn.datetime.Age");
        FunctionLib.addFunction("datetime", "com.scudata.expression.fn.datetime.DateTime");
        FunctionLib.addFunction("day", "com.scudata.expression.fn.datetime.Day");
        FunctionLib.addFunction("hour", "com.scudata.expression.fn.datetime.Hour");
        FunctionLib.addFunction("minute", "com.scudata.expression.fn.datetime.Minute");
        FunctionLib.addFunction("month", "com.scudata.expression.fn.datetime.Month");
        FunctionLib.addFunction("now", "com.scudata.expression.fn.datetime.Now");
        FunctionLib.addFunction("second", "com.scudata.expression.fn.datetime.Second");
        FunctionLib.addFunction("millisecond", "com.scudata.expression.fn.datetime.Millisecond");
        FunctionLib.addFunction("date", "com.scudata.expression.fn.datetime.ToDate");
        FunctionLib.addFunction("time", "com.scudata.expression.fn.datetime.ToTime");
        FunctionLib.addFunction("year", "com.scudata.expression.fn.datetime.Year");
        FunctionLib.addFunction("periods", "com.scudata.expression.fn.datetime.Period");
        FunctionLib.addFunction("interval", "com.scudata.expression.fn.datetime.Interval");
        FunctionLib.addFunction("elapse", "com.scudata.expression.fn.datetime.Elapse");
        FunctionLib.addFunction("days", "com.scudata.expression.fn.datetime.Days");
        FunctionLib.addFunction("pdate", "com.scudata.expression.fn.datetime.PDate");
        FunctionLib.addFunction("deq", "com.scudata.expression.fn.datetime.DateEqual");
        FunctionLib.addFunction("workday", "com.scudata.expression.fn.datetime.WorkDay");
        FunctionLib.addFunction("workdays", "com.scudata.expression.fn.datetime.WorkDays");
        FunctionLib.addFunction("itx", "com.scudata.expression.fn.datetime.ITX");
        FunctionLib.addFunction("addx", "com.scudata.expression.fn.datetime.Addx");
        FunctionLib.addFunction("subx", "com.scudata.expression.fn.datetime.Subx");
        FunctionLib.addFunction("cmpx", "com.scudata.expression.fn.datetime.Cmpx");
        FunctionLib.addFunction("abs", "com.scudata.expression.fn.math.Abs");
        FunctionLib.addFunction("and", "com.scudata.expression.fn.math.And");
        FunctionLib.addFunction("acos", "com.scudata.expression.fn.math.Arccos");
        FunctionLib.addFunction("acosh", "com.scudata.expression.fn.math.Arccosh");
        FunctionLib.addFunction("asin", "com.scudata.expression.fn.math.Arcsin");
        FunctionLib.addFunction("asinh", "com.scudata.expression.fn.math.Arcsinh");
        FunctionLib.addFunction("atan", "com.scudata.expression.fn.math.Arctan");
        FunctionLib.addFunction("atanh", "com.scudata.expression.fn.math.Arctanh");
        FunctionLib.addFunction("bin", "com.scudata.expression.fn.math.Bin");
        FunctionLib.addFunction("bits", "com.scudata.expression.fn.math.Bits");
        FunctionLib.addFunction("bit1", "com.scudata.expression.fn.math.Bit1");
        FunctionLib.addFunction("ceil", "com.scudata.expression.fn.math.Ceiling");
        FunctionLib.addFunction("combin", "com.scudata.expression.fn.math.Combin");
        FunctionLib.addFunction("cos", "com.scudata.expression.fn.math.Cos");
        FunctionLib.addFunction("cosh", "com.scudata.expression.fn.math.Cosh");
        FunctionLib.addFunction("digits", "com.scudata.expression.fn.math.Digits");
        FunctionLib.addFunction("exp", "com.scudata.expression.fn.math.Exp");
        FunctionLib.addFunction("fact", "com.scudata.expression.fn.math.Fact");
        FunctionLib.addFunction("floor", "com.scudata.expression.fn.math.Floor");
        FunctionLib.addFunction("gcd", "com.scudata.expression.fn.math.Gcd");
        FunctionLib.addFunction("hash", "com.scudata.expression.fn.math.Hash");
        FunctionLib.addFunction("hex", "com.scudata.expression.fn.math.Hex");
        FunctionLib.addFunction("inf", "com.scudata.expression.fn.math.Inf");
        FunctionLib.addFunction("lcm", "com.scudata.expression.fn.math.Lcm");
        FunctionLib.addFunction("lg", "com.scudata.expression.fn.math.Loga");
        FunctionLib.addFunction("ln", "com.scudata.expression.fn.math.Log");
        FunctionLib.addFunction("not", "com.scudata.expression.fn.math.Not");
        FunctionLib.addFunction("or", "com.scudata.expression.fn.math.Or");
        FunctionLib.addFunction("permut", "com.scudata.expression.fn.math.Permut");
        FunctionLib.addFunction("pi", "com.scudata.expression.fn.math.Pi");
        FunctionLib.addFunction("power", "com.scudata.expression.fn.math.Pow");
        FunctionLib.addFunction("product", "com.scudata.expression.fn.math.Product");
        FunctionLib.addFunction("rand", "com.scudata.expression.fn.math.Rand");
        FunctionLib.addFunction("round", "com.scudata.expression.fn.math.Round");
        FunctionLib.addFunction("remainder", "com.scudata.expression.fn.math.Remainder");
        FunctionLib.addFunction("shift", "com.scudata.expression.fn.math.Shift");
        FunctionLib.addFunction("sign", "com.scudata.expression.fn.math.Sign");
        FunctionLib.addFunction("sin", "com.scudata.expression.fn.math.Sin");
        FunctionLib.addFunction("sinh", "com.scudata.expression.fn.math.Sinh");
        FunctionLib.addFunction("sqrt", "com.scudata.expression.fn.math.Sqrt");
        FunctionLib.addFunction("tan", "com.scudata.expression.fn.math.Tan");
        FunctionLib.addFunction("tanh", "com.scudata.expression.fn.math.Tanh");
        FunctionLib.addFunction("xor", "com.scudata.expression.fn.math.Xor");
        FunctionLib.addFunction("fill", "com.scudata.expression.fn.string.Fill");
        FunctionLib.addFunction("left", "com.scudata.expression.fn.string.Left");
        FunctionLib.addFunction("len", "com.scudata.expression.fn.string.Len");
        FunctionLib.addFunction("like", "com.scudata.expression.fn.string.Like");
        FunctionLib.addFunction("lower", "com.scudata.expression.fn.string.Lower");
        FunctionLib.addFunction("mid", "com.scudata.expression.fn.string.Mid");
        FunctionLib.addFunction("pos", "com.scudata.expression.fn.string.Pos");
        FunctionLib.addFunction("replace", "com.scudata.expression.fn.string.Replace");
        FunctionLib.addFunction("right", "com.scudata.expression.fn.string.Right");
        FunctionLib.addFunction("trim", "com.scudata.expression.fn.string.Trim");
        FunctionLib.addFunction("upper", "com.scudata.expression.fn.string.Upper");
        FunctionLib.addFunction("pad", "com.scudata.expression.fn.string.Pad");
        FunctionLib.addFunction("rands", "com.scudata.expression.fn.string.Rands");
        FunctionLib.addFunction("concat", "com.scudata.expression.fn.string.Concat");
        FunctionLib.addFunction("urlencode", "com.scudata.expression.fn.string.URLEncode");
        FunctionLib.addFunction("charencode", "com.scudata.expression.fn.string.CharEncode");
        FunctionLib.addFunction("base64", "com.scudata.expression.fn.string.Base64");
        FunctionLib.addFunction("md5", "com.scudata.expression.fn.string.MD5Encrypt");
        FunctionLib.addFunction("substr", "com.scudata.expression.fn.string.SubString");
        FunctionLib.addFunction("aes", "com.scudata.expression.fn.string.AESEncrypt");
        FunctionLib.addFunction("des", "com.scudata.expression.fn.string.DESEncrypt");
        FunctionLib.addFunction("desede", "com.scudata.expression.fn.string.DESedeEncrypt");
        FunctionLib.addFunction("rsa", "com.scudata.expression.fn.string.RSAEncrypt");
        FunctionLib.addMemberFunction("words", "com.scudata.expression.mfn.string.Words");
        FunctionLib.addMemberFunction("split", "com.scudata.expression.mfn.string.Split");
        FunctionLib.addMemberFunction("sqlparse", "com.scudata.expression.mfn.string.SQLParse");
        FunctionLib.addMemberFunction("sqltranslate", "com.scudata.expression.mfn.string.SQLTranslate");
        FunctionLib.addMemberFunction("sbs", "com.scudata.expression.mfn.string.Sbs");
        FunctionLib.addFunction("ifv", "com.scudata.expression.fn.convert.IfVariable");
        FunctionLib.addFunction("ifa", "com.scudata.expression.fn.convert.IfSequence");
        FunctionLib.addFunction("ifr", "com.scudata.expression.fn.convert.IfRecord");
        FunctionLib.addFunction("ift", "com.scudata.expression.fn.convert.IfTable");
        FunctionLib.addFunction("ifdate", "com.scudata.expression.fn.convert.IfDate");
        FunctionLib.addFunction("iftime", "com.scudata.expression.fn.convert.IfTime");
        FunctionLib.addFunction("ifnumber", "com.scudata.expression.fn.convert.IfNumber");
        FunctionLib.addFunction("ifstring", "com.scudata.expression.fn.convert.IfString");
        FunctionLib.addFunction("typeof", "com.scudata.expression.fn.convert.Typeof");
        FunctionLib.addFunction("isalpha", "com.scudata.expression.fn.convert.IsAlpha");
        FunctionLib.addFunction("isdigit", "com.scudata.expression.fn.convert.IsDigit");
        FunctionLib.addFunction("islower", "com.scudata.expression.fn.convert.IsLower");
        FunctionLib.addFunction("isupper", "com.scudata.expression.fn.convert.IsUpper");
        FunctionLib.addFunction("uuid", "com.scudata.expression.fn.CreateUUID");
        FunctionLib.addFunction("bool", "com.scudata.expression.fn.convert.ToBool");
        FunctionLib.addFunction("int", "com.scudata.expression.fn.convert.ToInteger");
        FunctionLib.addFunction("long", "com.scudata.expression.fn.convert.ToLong");
        FunctionLib.addFunction("float", "com.scudata.expression.fn.convert.ToDouble");
        FunctionLib.addFunction("number", "com.scudata.expression.fn.convert.ToNumber");
        FunctionLib.addFunction("string", "com.scudata.expression.fn.convert.ToString");
        FunctionLib.addFunction("decimal", "com.scudata.expression.fn.convert.ToBigDecimal");
        FunctionLib.addFunction("asc", "com.scudata.expression.fn.convert.ToAsc");
        FunctionLib.addFunction("char", "com.scudata.expression.fn.convert.ToChar");
        FunctionLib.addFunction("rgb", "com.scudata.expression.fn.convert.RGB");
        FunctionLib.addFunction("chn", "com.scudata.expression.fn.convert.ToChinese");
        FunctionLib.addFunction("parse", "com.scudata.expression.fn.convert.Parse");
        FunctionLib.addFunction("format", "com.scudata.expression.fn.convert.Format");
        FunctionLib.addFunction("json", "com.scudata.expression.fn.convert.Json");
        FunctionLib.addFunction("xml", "com.scudata.expression.fn.convert.Xml");
        FunctionLib.addFunction("var", "com.scudata.expression.fn.algebra.Var");
        FunctionLib.addFunction("mse", "com.scudata.expression.fn.algebra.Mse");
        FunctionLib.addFunction("mae", "com.scudata.expression.fn.algebra.Mae");
        FunctionLib.addFunction("dis", "com.scudata.expression.fn.algebra.Distance");
        FunctionLib.addFunction("I", "com.scudata.expression.fn.algebra.Identity");
        FunctionLib.addFunction("mul", "com.scudata.expression.fn.algebra.Mul");
        FunctionLib.addFunction("transpose", "com.scudata.expression.fn.algebra.Transpose");
        FunctionLib.addFunction("inverse", "com.scudata.expression.fn.algebra.Inverse");
        FunctionLib.addFunction("det", "com.scudata.expression.fn.algebra.Det");
        FunctionLib.addFunction("rankm", "com.scudata.expression.fn.algebra.Rankm");
        FunctionLib.addFunction("linefit", "com.scudata.expression.fn.algebra.Linefit");
        FunctionLib.addFunction("polyfit", "com.scudata.expression.fn.algebra.Polyfit");
        FunctionLib.addFunction("norm", "com.scudata.expression.fn.algebra.Normalize");
        FunctionLib.addFunction("pearson", "com.scudata.expression.fn.algebra.Pearson");
        FunctionLib.addFunction("spearman", "com.scudata.expression.fn.algebra.Spearman");
    }

    public static void loadCustomFunctions(String fileName) {
        try {
            InputStream is = null;
            File file = new File(fileName);
            is = file.exists() ? new FileInputStream(file) : FunctionLib.class.getResourceAsStream(fileName);
            if (is == null) {
                throw new Exception("load customFunction file inputstream failed.");
            }
            FunctionLib.loadCustomFunctions(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadCustomFunctions(InputStream is) {
        try {
            Properties properties = new Properties();
            properties.load(is);
            for (Property property : properties) {
                String name = property.getName();
                String value = property.getValue();
                int pos = value.indexOf(44);
                String type = value.substring(0, pos).trim();
                String cls = value.substring(pos + 1, value.length()).trim();
                if (type.equals("1")) {
                    FunctionLib.addMemberFunction(name, cls);
                    continue;
                }
                if (!type.equals("0")) continue;
                FunctionLib.addFunction(name, cls);
            }
        }
        catch (Throwable e) {
            Logger.error(e.getMessage());
        }
    }

    private static void _$1(InputStream is, ClassLoader loader) throws Exception {
        Properties properties = new Properties();
        properties.load(is);
        HashMap m0 = new HashMap();
        ArrayList<String> mfnNames = new ArrayList<String>();
        ArrayList mfns = new ArrayList();
        for (Property property : properties) {
            Class<?> cls;
            String name = property.getName();
            String value = property.getValue();
            int pos = value.indexOf(44);
            String type = value.substring(0, pos).trim();
            String clsName = value.substring(pos + 1, value.length()).trim();
            if (type.equals("0")) {
                if (_$3.containsKey(name)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RuntimeException(mm.getMessage("FunctionLib.repeatedFunction") + name);
                }
                cls = loader.loadClass(clsName);
                m0.put(name, cls);
                continue;
            }
            if (!type.equals("1")) continue;
            cls = loader.loadClass(clsName);
            mfnNames.add(name);
            mfns.add(cls);
        }
        _$3.putAll(m0);
        int size = mfnNames.size();
        for (int i = 0; i < size; ++i) {
            FunctionLib.addMemberFunction((String)mfnNames.get(i), (Class)mfns.get(i));
        }
    }

    public static void loadExtLibrary(File path) {
        File[] fs = path.listFiles();
        ArrayList<URL> list = new ArrayList<URL>();
        ArrayList<File> jars = new ArrayList<File>();
        for (File f : fs) {
            if (!f.getName().endsWith(".jar")) continue;
            jars.add(f);
            try {
                list.add(new URL("file", null, 0, f.getCanonicalPath()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        URLClassLoader loader = new URLClassLoader(list.toArray(new URL[0]), FunctionLib.class.getClassLoader());
        Pattern p = Pattern.compile("com/scudata/lib/(\\w+)/functions.properties");
        for (File f : jars) {
            JarFile jf = null;
            try {
                jf = new JarFile(f);
                Enumeration<JarEntry> jee = jf.entries();
                while (jee.hasMoreElements()) {
                    JarEntry je = jee.nextElement();
                    Matcher m = p.matcher(je.getName());
                    if (!m.matches()) continue;
                    String libName = m.group(1);
                    try {
                        InputStream in = jf.getInputStream(je);
                        FunctionLib._$1(in, loader);
                        Logger.info("load library [" + libName + "] from " + path.getName());
                    }
                    catch (Throwable e) {
                        Logger.error("failed to load library [" + libName + "] from " + path.getName(), e);
                    }
                }
                jf.close();
            }
            catch (Exception e) {
                Logger.error("failed to open jar file" + path.getName() + "/" + f.getName(), e);
            }
        }
    }

    public static Object executeMemberFunction(Object leftValue, String fnName, String param, String option, Context ctx) {
        MemberFunction fn = FunctionLib.newMemberFunction(fnName);
        fn.setParameter(null, ctx, param);
        fn.setOption(option);
        Constant leftNode = new Constant(leftValue);
        DotOperator dot = new DotOperator();
        dot.setLeft(leftNode);
        dot.setRight(fn);
        return dot.calculate(ctx);
    }

    public static void addDFXFunction(String fnName, String dfxPathName, String opt) {
        if (FunctionLib.isFnName(fnName)) {
            MessageManager mm = EngineMessage.get();
            throw new RuntimeException(mm.getMessage("FunctionLib.repeatedFunction") + fnName);
        }
        DfxFunction old = _$1.put(fnName, new DfxFunction(dfxPathName, opt));
        if (old != null) {
            DfxManager.getInstance().clearDfx(dfxPathName);
        }
    }

    public static void addDFXFunction(String fnName, PgmCellSet.FuncInfo funcInfo) {
        if (FunctionLib.isFnName(fnName)) {
            MessageManager mm = EngineMessage.get();
            throw new RuntimeException(mm.getMessage("FunctionLib.repeatedFunction") + fnName);
        }
        _$1.put(fnName, new DfxFunction(funcInfo));
    }

    public static void removeDFXFunction(String fnName) {
        _$1.remove(fnName);
    }

    public static DfxFunction getDFXFunction(String fnName) {
        return _$1.get(fnName);
    }

    static {
        FunctionLib._$1();
    }
}

