/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.CellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Move
extends Function {
    private Node _$1;

    public Move() {
        this.priority = 18;
    }

    @Override
    public void setLeft(Node node) {
        this._$1 = node;
    }

    @Override
    public Node getLeft() {
        return this._$1;
    }

    @Override
    protected boolean containParam(String name) {
        if (this.getLeft().containParam(name)) {
            return true;
        }
        return super.containParam(name);
    }

    @Override
    protected void getUsedParams(Context ctx, ParamList resultList) {
        this.getLeft().getUsedParams(ctx, resultList);
        super.getUsedParams(ctx, resultList);
    }

    @Override
    public void getUsedFields(Context ctx, List<String> resultList) {
        this.getLeft().getUsedFields(ctx, resultList);
        super.getUsedFields(ctx, resultList);
    }

    @Override
    protected void getUsedCells(List<INormalCell> resultList) {
        this.getLeft().getUsedCells(resultList);
        super.getUsedCells(resultList);
    }

    @Override
    public void reset() {
        this.getLeft().reset();
        super.reset();
    }

    @Override
    public Node optimize(Context ctx) {
        this.param.optimize(ctx);
        this._$1 = this.getLeft().optimize(ctx);
        return this;
    }

    @Override
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("function.missingParam"));
        }
        if (this._$1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"[]\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this._$1.checkValidity();
    }

    @Override
    public boolean canCalculateAll() {
        if (!this._$1.canCalculateAll()) {
            return false;
        }
        return this.param.canCalculateAll();
    }

    @Override
    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            return this.getLeft().move(this, ctx);
        }
        return this.getLeft().moves(this, ctx);
    }

    @Override
    public Object assign(Object value, Context ctx) {
        if (this.cs instanceof CellSet) {
            return this.getLeft().moveAssign(this, value, ctx);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("assign.needVar"));
    }

    public int calculateIndex(Current current, Context ctx) {
        return Move.calculateIndex(current, this.param, ctx);
    }

    public static int calculateIndex(Current current, IParam param, Context ctx) {
        Object posObj = param.getLeafExpression().calculate(ctx);
        if (!(posObj instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("function.paramTypeError"));
        }
        int pos = ((Number)posObj).intValue() + current.getCurrentIndex();
        if (pos > 0 && pos <= current.length()) {
            return pos;
        }
        return 0;
    }

    public int[] calculateIndexRange(Current current, Context ctx) {
        return Move.calculateIndexRange(current, this.param, ctx);
    }

    public static int[] calculateIndexRange(Current current, IParam param, Context ctx) {
        Object obj;
        Number start = null;
        Number end = null;
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("function.invalidParam"));
        }
        IParam startParam = param.getSub(0);
        IParam endParam = param.getSub(1);
        if (startParam != null) {
            obj = startParam.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("[]" + mm.getMessage("function.paramTypeError"));
            }
            start = (Number)obj;
        }
        if (endParam != null) {
            obj = endParam.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("[]" + mm.getMessage("function.paramTypeError"));
            }
            end = (Number)obj;
        }
        return Move._$1(current, start, end);
    }

    private static int[] _$1(Current current, Number start, Number end) {
        int endSeq;
        int startSeq;
        int curIndex = current.getCurrentIndex();
        if (curIndex < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.seriesNotInStack"));
        }
        int len = current.length();
        if (start == null) {
            startSeq = 1;
        } else {
            startSeq = curIndex + start.intValue();
            if (startSeq < 1) {
                startSeq = 1;
            }
        }
        if (end == null) {
            endSeq = len;
        } else {
            endSeq = curIndex + end.intValue();
            if (endSeq > len) {
                endSeq = len;
            }
        }
        if (startSeq <= endSeq) {
            return new int[]{startSeq, endSeq};
        }
        return null;
    }

    public static Sequence getFieldValues(Current current, String fieldName, int start, int end) {
        Object obj;
        Sequence result = new Sequence(end - start + 1);
        int col = -1;
        BaseRecord prevRecord = null;
        while (start <= end) {
            if ((obj = current.get(start++)) != null) {
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                prevRecord = (BaseRecord)obj;
                col = prevRecord.getFieldIndex(fieldName);
                if (col < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                }
                result.add(prevRecord.getFieldValue(col));
                break;
            }
            result.add(null);
        }
        while (start <= end) {
            obj = current.get(start);
            if (obj != null) {
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                BaseRecord cur = (BaseRecord)obj;
                if (!prevRecord.isSameDataStruct(cur)) {
                    col = cur.getFieldIndex(fieldName);
                    if (col < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(fieldName + mm.getMessage("ds.fieldNotExist"));
                    }
                    prevRecord = cur;
                }
                result.add(cur.getFieldValue(col));
            } else {
                result.add(null);
            }
            ++start;
        }
        return result;
    }

    public static Sequence getFieldValues(Current current, int field, int start, int end) {
        Sequence result = new Sequence(end - start + 1);
        while (start <= end) {
            Object obj = current.get(start);
            if (obj != null) {
                if (!(obj instanceof BaseRecord)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needPmt"));
                }
                BaseRecord cur = (BaseRecord)obj;
                result.add(cur.getFieldValue2(field));
            } else {
                result.add(null);
            }
            ++start;
        }
        return result;
    }

    @Override
    public IArray calculateAll(Context ctx) {
        IArray posArray;
        if (this.param.isLeaf() && (posArray = this.param.getLeafExpression().calculateAll(ctx)) instanceof ConstArray) {
            int move = posArray.getInt(1);
            IArray array = this._$1.calculateAll(ctx);
            int len = array.size();
            if (move > 0) {
                if (move < len) {
                    IArray result = array.newInstance(len);
                    result.addAll(array, move + 1, len - move);
                    for (int i = result.size(); i <= len; ++i) {
                        result.pushNull();
                    }
                    return result;
                }
                return new ConstArray(null, len);
            }
            if (move < 0) {
                int end = len + move;
                if (end > 0) {
                    IArray result = array.newInstance(len);
                    for (int i = end + 1; i <= len; ++i) {
                        result.pushNull();
                    }
                    result.addAll(array, end);
                    return result;
                }
                return new ConstArray(null, len);
            }
            return array;
        }
        return super.calculateAll(ctx);
    }

    @Override
    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        return this.calculateAll(ctx);
    }
}

