/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.dm.Context;
import com.scudata.expression.Operator;

public abstract class Relation
extends Operator {
    public static final int EQUAL = 1;
    public static final int GREATER = 2;
    public static final int GREATER_EQUAL = 3;
    public static final int LESS = 4;
    public static final int LESS_EQUAL = 5;
    public static final int NOT_EQUAL = 6;
    public static final int AND = 7;
    public static final int OR = 8;
    public static final int UNMATCH = -1;
    public static final int PARTICALMATCH = 0;
    public static final int ALLMATCH = 1;

    public static int getInverseRelation(int ralation) {
        switch (ralation) {
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return ralation;
    }

    public abstract int getRelation();

    public abstract int getInverseRelation();

    public IArray calculateAll(Context ctx) {
        IArray leftArray = this.left.calculateAll(ctx);
        IArray rightArray = this.right.calculateAll(ctx);
        return leftArray.calcRelation(rightArray, this.getRelation());
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        BoolArray result = ArrayUtil.booleanValue(signArray, sign);
        IArray leftArray = this.left.calculateAll(ctx, result, true);
        IArray rightArray = this.right.calculateAll(ctx, result, true);
        leftArray.calcRelations(rightArray, this.getRelation(), result, true);
        return result;
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        BoolArray result = leftResult.isTrue();
        IArray leftArray = this.left.calculateAll(ctx, result, true);
        IArray rightArray = this.right.calculateAll(ctx, result, true);
        leftArray.calcRelations(rightArray, this.getRelation(), result, true);
        return result;
    }

    public BoolArray calculateOr(Context ctx, IArray leftResult) {
        BoolArray result = leftResult.isTrue();
        IArray leftArray = this.left.calculateAll(ctx, result, false);
        IArray rightArray = this.right.calculateAll(ctx, result, false);
        leftArray.calcRelations(rightArray, this.getRelation(), result, false);
        return result;
    }
}

