/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;

public class ValueList
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public Node optimize(Context ctx, boolean optSequence) {
        if (optSequence) {
            if (this.param != null) {
                if (this.param.optimize(ctx)) {
                    return new Constant(this.calculate(ctx));
                }
                return this;
            }
            return new Constant(new Sequence(0));
        }
        return this.optimize(ctx);
    }

    public Object calculate(Context ctx) {
        if (this.param == null) {
            return new Sequence(0);
        }
        char type = this.param.getType();
        if (type == '\u0000') {
            Expression exp = this.param.getLeafExpression();
            Sequence series = new Sequence(1);
            series.add(exp.calculate(ctx));
            return series;
        }
        if (type == ',') {
            int size = this.param.getSubSize();
            Sequence series = new Sequence(size);
            for (int i = 0; i < size; ++i) {
                IParam sub = this.param.getSub(i);
                if (sub == null) {
                    series.add(null);
                    continue;
                }
                if (sub.isLeaf()) {
                    Expression exp = sub.getLeafExpression();
                    series.add(exp.calculate(ctx));
                    continue;
                }
                Sequence subSeries = this._$1(sub.getSub(0), sub.getSub(1), ctx);
                series.addAll(subSeries);
            }
            return series;
        }
        if (type == ':') {
            return this._$1(this.param.getSub(0), this.param.getSub(1), ctx);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("[]" + mm.getMessage("function.invalidParam"));
    }

    private Sequence _$1(IParam startParam, IParam endParam, Context ctx) {
        if (startParam == null || endParam == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("function.invalidParam"));
        }
        Expression startExp = startParam.getLeafExpression();
        Expression endExp = endParam.getLeafExpression();
        INormalCell startCell = startExp.calculateCell(ctx);
        if (startCell == null) {
            return null;
        }
        INormalCell endCell = endExp.calculateCell(ctx);
        if (endCell == null) {
            return null;
        }
        ICellSet cs = startCell.getCellSet();
        if (endCell.getCellSet() != cs) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("function.invalidParam"));
        }
        int left = startCell.getCol();
        int top = startCell.getRow();
        int right = endCell.getCol();
        int bottom = endCell.getRow();
        if (top <= bottom) {
            if (left <= right) {
                Sequence series = new Sequence((right - left + 1) * (bottom - top + 1));
                for (int r = top; r <= bottom; ++r) {
                    for (int c = left; c <= right; ++c) {
                        series.add(cs.getCell(r, c).getValue(true));
                    }
                }
                return series;
            }
            Sequence series = new Sequence((left - right + 1) * (bottom - top + 1));
            for (int r = top; r <= bottom; ++r) {
                for (int c = left; c >= right; --c) {
                    series.add(cs.getCell(r, c).getValue(true));
                }
            }
            return series;
        }
        if (left <= right) {
            Sequence series = new Sequence((right - left + 1) * (top - bottom + 1));
            for (int r = top; r >= bottom; --r) {
                for (int c = left; c <= right; ++c) {
                    series.add(cs.getCell(r, c).getValue(true));
                }
            }
            return series;
        }
        Sequence series = new Sequence((left - right + 1) * (top - bottom + 1));
        for (int r = top; r >= bottom; --r) {
            for (int c = left; c >= right; --c) {
                series.add(cs.getCell(r, c).getValue(true));
            }
        }
        return series;
    }
}

