/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class Arguments
extends Function {
    public Object calculate(Context ctx) {
        ParamList paramList = null;
        if (this.param != null) {
            FileObject fo;
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (obj instanceof FileObject) {
                fo = (FileObject)obj;
            } else if (obj instanceof String) {
                fo = new FileObject((String)obj);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("arguments" + mm.getMessage("function.paramTypeError"));
            }
            PgmCellSet cs = fo.readPgmCellSet();
            paramList = cs.getParamList();
        } else if (this.cs instanceof PgmCellSet) {
            paramList = ((PgmCellSet)this.cs).getParamList();
        }
        if (paramList != null && paramList.count() > 0) {
            int count = paramList.count();
            Sequence seq = new Sequence(count);
            for (int i = 0; i < count; ++i) {
                String name = paramList.get(i).getName();
                seq.add(name);
            }
            return seq;
        }
        return new Sequence(0);
    }

    public IArray calculateAll(Context ctx) {
        Sequence sequence = ctx.getComputeStack().getTopSequence();
        Object value = this.calculate(ctx);
        return new ConstArray(value, sequence.length());
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        Sequence sequence = ctx.getComputeStack().getTopSequence();
        Object value = this.calculate(ctx);
        return new ConstArray(value, sequence.length());
    }
}

