/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.UUID;
import com.scudata.dm.Context;
import com.scudata.dm.DfxManager;
import com.scudata.dm.FileObject;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.CallJob;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Call
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("call" + mm.getMessage("function.missingParam"));
        }
    }

    public Node optimize(Context ctx) {
        this.param.optimize(ctx);
        return this;
    }

    public Object calculate(Context ctx) {
        PgmCellSet pcs = this.getCallPgmCellSet(ctx);
        boolean nopt = false;
        boolean useCache = true;
        boolean fopt = false;
        if (this.option != null) {
            if (this.option.indexOf(110) != -1) {
                nopt = true;
            }
            if (this.option.indexOf(114) != -1) {
                useCache = false;
            }
            if (this.option.indexOf(102) != -1) {
                fopt = true;
            }
        }
        if (nopt) {
            String uuid = UUID.randomUUID().toString();
            JobSpace jobSpace = JobSpaceManager.getSpace(uuid);
            pcs.getContext().setJobSpace(jobSpace);
            CallJob job = new CallJob(pcs, this.option);
            Thread thread = new Thread(job);
            thread.start();
            return null;
        }
        Object val = pcs.execute();
        if (fopt) {
            boolean isGlobal;
            HashMap<String, PgmCellSet.FuncInfo> map = pcs.getFunctionMap();
            Set<Map.Entry<String, PgmCellSet.FuncInfo>> set = map.entrySet();
            Iterator<Map.Entry<String, PgmCellSet.FuncInfo>> iterator = set.iterator();
            boolean bl = isGlobal = this.option.indexOf(106) == -1;
            while (iterator.hasNext()) {
                Map.Entry<String, PgmCellSet.FuncInfo> entry = iterator.next();
                ctx.addDFXFunction(entry.getKey(), entry.getValue(), isGlobal);
            }
        }
        if (useCache) {
            pcs.reset();
            DfxManager.getInstance().putDfx(pcs);
        }
        return val;
    }

    public String getDfxPathName(Context ctx) {
        FileObject fo;
        IParam param = this.param;
        if (!param.isLeaf() && (param = param.getSub(0)) == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("call" + mm.getMessage("function.invalidParam"));
        }
        Object obj = param.getLeafExpression().calculate(ctx);
        if (obj instanceof String) {
            fo = new FileObject((String)obj, null, "s", ctx);
        } else if (obj instanceof FileObject) {
            fo = (FileObject)obj;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("call" + mm.getMessage("function.paramTypeError"));
        }
        File file = fo.getLocalFile().getFile();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public PgmCellSet getCallPgmCellSet(Context ctx) {
        PgmCellSet pcs;
        block21: {
            DfxManager dfxManager;
            boolean useCache;
            IParam param;
            block20: {
                param = this.param;
                useCache = this.option == null || this.option.indexOf(114) == -1;
                dfxManager = DfxManager.getInstance();
                if (!param.isLeaf()) break block20;
                Object obj = param.getLeafExpression().calculate(ctx);
                if (obj instanceof String) {
                    pcs = useCache ? dfxManager.removeDfx((String)obj, ctx) : DfxManager.readDfx((String)obj, ctx);
                } else if (obj instanceof FileObject) {
                    pcs = useCache ? dfxManager.removeDfx((FileObject)obj, ctx) : DfxManager.readDfx((FileObject)obj, ctx);
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("call" + mm.getMessage("function.paramTypeError"));
                }
                pcs.setParamToContext();
                break block21;
            }
            IParam sub0 = param.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("call" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub0.getLeafExpression().calculate(ctx);
            if (obj instanceof String) {
                pcs = useCache ? dfxManager.removeDfx((String)obj, ctx) : DfxManager.readDfx((String)obj, ctx);
            } else if (obj instanceof FileObject) {
                pcs = useCache ? dfxManager.removeDfx((FileObject)obj, ctx) : DfxManager.readDfx((FileObject)obj, ctx);
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("call" + mm.getMessage("function.paramTypeError"));
            }
            pcs.setParamToContext();
            ParamList list = pcs.getParamList();
            if (list == null) break block21;
            Context curCtx = pcs.getContext();
            if (pcs.isDynamicParam()) {
                Object val;
                int last;
                int paramCount = list.count();
                int giveCount = param.getSubSize() - 1;
                if (giveCount >= paramCount) {
                    last = paramCount;
                    Sequence values = new Sequence();
                    for (int i = last; i <= giveCount; ++i) {
                        IParam sub = param.getSub(i);
                        if (sub != null) {
                            val = sub.getLeafExpression().calculate(ctx);
                            values.add(val);
                            continue;
                        }
                        values.add(null);
                    }
                    Param p = list.get(paramCount - 1);
                    curCtx.setParamValue(p.getName(), values);
                } else {
                    last = giveCount + 1;
                }
                for (int i = 1; i < last; ++i) {
                    IParam sub = param.getSub(i);
                    Param p = list.get(i - 1);
                    if (sub != null) {
                        val = sub.getLeafExpression().calculate(ctx);
                        curCtx.setParamValue(p.getName(), val);
                        continue;
                    }
                    curCtx.setParamValue(p.getName(), p.getValue());
                }
            } else {
                int size = param.getSubSize();
                if (size - 1 > list.count()) {
                    size = list.count() + 1;
                }
                for (int i = 1; i < size; ++i) {
                    IParam sub = param.getSub(i);
                    Param p = list.get(i - 1);
                    if (sub != null) {
                        Object val = sub.getLeafExpression().calculate(ctx);
                        curCtx.setParamValue(p.getName(), val);
                        continue;
                    }
                    curCtx.setParamValue(p.getName(), p.getValue());
                }
            }
        }
        return pcs;
    }

    public void finish(PgmCellSet pcs) {
        if (this.option == null || this.option.indexOf(114) == -1) {
            pcs.reset();
            DfxManager.getInstance().putDfx(pcs);
        }
    }
}

