/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Cand
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cand" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        IParam param = this.param;
        if (param.isLeaf()) {
            Object obj = param.getLeafExpression().calculate(ctx);
            return Variant.isTrue(obj);
        }
        int size = param.getSubSize();
        for (int i = 0; i < size; ++i) {
            IParam sub = param.getSub(i);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cand" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub.getLeafExpression().calculate(ctx);
            if (!Variant.isFalse(obj)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

