/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.cellset.ICellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamParser;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Case
extends Function {
    public void setParameter(ICellSet cs, Context ctx, String param) {
        this.strParam = param;
        this.cs = cs;
        this.param = ParamParser.parse(param, cs, ctx, false, false);
    }

    public byte calcExpValueType(Context ctx) {
        return 102;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("case" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        IParam param = this.param;
        IParam defaultParam = null;
        if (param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("case" + mm.getMessage("function.invalidParam"));
            }
            defaultParam = param.getSub(1);
            if ((param = param.getSub(0)) == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("case" + mm.getMessage("function.invalidParam"));
            }
        }
        if (param.getType() != ',') {
            MessageManager mm = EngineMessage.get();
            throw new RQException("case" + mm.getMessage("function.invalidParam"));
        }
        IParam sub = param.getSub(0);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("case" + mm.getMessage("function.invalidParam"));
        }
        Object val = sub.getLeafExpression().calculate(ctx);
        int size = param.getSubSize();
        for (int i = 1; i < size; ++i) {
            Object condition;
            sub = param.getSub(i);
            if (sub.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("case" + mm.getMessage("function.invalidParam"));
            }
            IParam p = sub.getSub(0);
            Object object = condition = p == null ? null : p.getLeafExpression().calculate(ctx);
            if (!Variant.isEquals(val, condition)) continue;
            p = sub.getSub(1);
            return p == null ? null : p.getLeafExpression().calculate(ctx);
        }
        if (defaultParam != null) {
            return defaultParam.getLeafExpression().calculate(ctx);
        }
        return null;
    }

    public IArray calculateAll(Context ctx) {
        IParam param = this.param;
        IParam defaultParam = null;
        if (param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("case" + mm.getMessage("function.invalidParam"));
            }
            defaultParam = param.getSub(1);
            if ((param = param.getSub(0)) == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("case" + mm.getMessage("function.invalidParam"));
            }
        }
        if (param.getType() != ',') {
            MessageManager mm = EngineMessage.get();
            throw new RQException("case" + mm.getMessage("function.invalidParam"));
        }
        IParam sub = param.getSub(0);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("case" + mm.getMessage("function.invalidParam"));
        }
        IArray valueArray = sub.getLeafExpression().calculateAll(ctx);
        BoolArray signArray = null;
        IArray resultArray = null;
        int size = param.getSubSize();
        for (int i = 1; i < size; ++i) {
            IArray curValueArray;
            sub = param.getSub(i);
            if (sub.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("case" + mm.getMessage("function.invalidParam"));
            }
            IParam sub1 = sub.getSub(0);
            IParam sub2 = sub.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("case" + mm.getMessage("function.invalidParam"));
            }
            if (i == 1) {
                curValueArray = sub1.getLeafExpression().calculateAll(ctx);
                signArray = valueArray.calcRelation(curValueArray, 1);
                resultArray = sub2.getLeafExpression().calculateAll(ctx, signArray, true);
                continue;
            }
            curValueArray = sub1.getLeafExpression().calculateAll(ctx, signArray, false);
            IArray curResultArray = sub2.getLeafExpression().calculateAll(ctx, signArray, false);
            resultArray = resultArray.combine((IArray)signArray, curResultArray);
            valueArray.calcRelations(curValueArray, 1, signArray, false);
        }
        if (defaultParam != null) {
            IArray curValueArray = defaultParam.getLeafExpression().calculateAll(ctx, signArray, false);
            return resultArray.combine((IArray)signArray, curValueArray);
        }
        boolean[] signs = signArray.getDatas();
        int len = signs.length;
        for (int i = 1; i < len; ++i) {
            if (signs[i]) continue;
            resultArray.set(i, null);
        }
        return resultArray;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        return this.calculateAll(ctx);
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        BoolArray result = leftResult.isTrue();
        IArray array = this.calculateAll(ctx);
        int size = result.size();
        for (int i = 1; i <= size; ++i) {
            if (!result.isTrue(i) || !array.isFalse(i)) continue;
            result.set(i, false);
        }
        return result;
    }
}

