/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.CellLocation;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;

public class CellName
extends Function {
    private Expression _$2;
    private Expression _$1;

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cellname" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cellname" + mm.getMessage("function.invalidParam"));
        }
        IParam rowParam = this.param.getSub(0);
        IParam colParam = this.param.getSub(1);
        if (rowParam == null || colParam == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cellname" + mm.getMessage("function.invalidParam"));
        }
        this._$2 = rowParam.getLeafExpression();
        this._$1 = colParam.getLeafExpression();
    }

    public Object calculate(Context ctx) {
        Object row = this._$2.calculate(ctx);
        if (!(row instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cellname" + mm.getMessage("function.paramTypeError"));
        }
        Object col = this._$1.calculate(ctx);
        if (!(col instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cellname" + mm.getMessage("function.paramTypeError"));
        }
        return CellLocation.getCellId(((Number)row).intValue(), ((Number)col).intValue());
    }

    public IArray calculateAll(Context ctx) {
        IArray rowArray = this._$2.calculateAll(ctx);
        IArray colArray = this._$1.calculateAll(ctx);
        if (!rowArray.isNumberArray() || !colArray.isNumberArray()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cellname" + mm.getMessage("function.paramTypeError"));
        }
        int len = rowArray.size();
        if (rowArray instanceof ConstArray && colArray instanceof ConstArray) {
            if (rowArray.isNull(1) || colArray.isNull(1)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cellname" + mm.getMessage("function.paramTypeError"));
            }
            int row = ((ConstArray)rowArray).getInt(1);
            int col = ((ConstArray)colArray).getInt(1);
            String id = CellLocation.getCellId(row, col);
            return new ConstArray(id, len);
        }
        ObjectArray result = new ObjectArray(len);
        result.setTemporary(true);
        for (int i = 1; i < len; ++i) {
            if (rowArray.isNull(i) || colArray.isNull(i)) {
                result.push(null);
                continue;
            }
            int row = rowArray.getInt(i);
            int col = colArray.getInt(i);
            String id = CellLocation.getCellId(row, col);
            result.push(id);
        }
        return result;
    }
}

