/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.LocalFile;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import java.io.File;

public class Directory
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public Object calculate(Context ctx) {
        File file;
        if (this.param == null) {
            Sequence seq = new Sequence(2);
            seq.add(Env.getMainPath());
            seq.add(Env.getTempPath());
            return seq;
        }
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (!(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("directory" + mm.getMessage("function.paramTypeError"));
            }
            LocalFile lf = new LocalFile((String)obj, null, ctx);
            file = lf.file();
        } else {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("directory" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("directory" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub0.getLeafExpression().calculate(ctx);
            if (!(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("directory" + mm.getMessage("function.paramTypeError"));
            }
            Object partition = sub1.getLeafExpression().calculate(ctx);
            if (partition == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("directory" + mm.getMessage("function.invalidParam"));
            }
            Integer p = -1;
            p = partition instanceof Number ? Integer.valueOf(((Number)partition).intValue()) : Integer.valueOf(Integer.parseInt(partition.toString()));
            LocalFile lf = new LocalFile((String)obj, null, p);
            file = lf.file();
        }
        boolean isDir = false;
        boolean isAbsolute = false;
        boolean isSub = false;
        boolean ignoreCase = false;
        if (this.option != null) {
            if (this.option.indexOf(109) != -1) {
                boolean b = file.mkdirs();
                return b;
            }
            if (this.option.indexOf(114) != -1) {
                boolean b = file.delete();
                return b;
            }
            isDir = this.option.indexOf(100) != -1;
            isAbsolute = this.option.indexOf(112) != -1;
            isSub = this.option.indexOf(115) != -1;
            ignoreCase = this.option.indexOf(99) != -1;
        }
        String pattern = null;
        if (!file.isDirectory()) {
            String os;
            pattern = file.getName();
            file = file.getParentFile();
            if (!ignoreCase && (os = System.getProperty("os.name").toLowerCase()).indexOf("windows") > -1) {
                ignoreCase = true;
            }
        }
        Sequence sequence = new Sequence();
        if (isDir) {
            this._$1(file, pattern, isAbsolute, isSub, ignoreCase, ctx, sequence);
        } else {
            this._$2(file, pattern, isAbsolute, isSub, ignoreCase, ctx, sequence);
        }
        sequence.trimToSize();
        return sequence;
    }

    private void _$2(File file, String pattern, boolean isAbsolute, boolean isSub, boolean ignoreCase, Context ctx, Sequence result) {
        if (file == null) {
            return;
        }
        File[] subs = file.listFiles();
        if (subs == null) {
            return;
        }
        for (File sub : subs) {
            if (sub.isFile()) {
                if (pattern != null && !StringUtils.matches(sub.getName(), pattern, ignoreCase)) continue;
                if (isAbsolute) {
                    String pathName = sub.getAbsolutePath();
                    result.add(LocalFile.removeMainPath(pathName, ctx));
                    continue;
                }
                result.add(sub.getName());
                continue;
            }
            if (!isSub) continue;
            this._$2(sub, pattern, isAbsolute, isSub, ignoreCase, ctx, result);
        }
    }

    private void _$1(File file, String pattern, boolean isAbsolute, boolean isSub, boolean ignoreCase, Context ctx, Sequence result) {
        File[] subs = file.listFiles();
        if (subs == null) {
            return;
        }
        for (File sub : subs) {
            if (!sub.isDirectory()) continue;
            if (pattern == null || StringUtils.matches(sub.getName(), pattern, ignoreCase)) {
                if (isAbsolute) {
                    String pathName = sub.getAbsolutePath();
                    result.add(LocalFile.removeMainPath(pathName, ctx));
                } else {
                    result.add(sub.getName());
                }
            }
            if (!isSub) continue;
            this._$1(sub, pattern, isAbsolute, isSub, ignoreCase, ctx, result);
        }
    }
}

