/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.cellset.ICellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Eval
extends Function {
    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public byte calcExpValueType(Context ctx) {
        return 102;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("eval" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object expStr;
        Sequence arg = null;
        if (this.param.isLeaf()) {
            expStr = this.param.getLeafExpression().calculate(ctx);
            if (expStr == null) {
                return null;
            }
            if (!(expStr instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("eval" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            int size = this.param.getSubSize();
            IParam sub = this.param.getSub(0);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("eval" + mm.getMessage("function.invalidParam"));
            }
            expStr = sub.getLeafExpression().calculate(ctx);
            if (expStr == null) {
                return null;
            }
            if (!(expStr instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("eval" + mm.getMessage("function.paramTypeError"));
            }
            arg = new Sequence(size);
            for (int i = 1; i < size; ++i) {
                sub = this.param.getSub(i);
                if (sub != null) {
                    arg.add(sub.getLeafExpression().calculate(ctx));
                    continue;
                }
                arg.add(null);
            }
        }
        if (this.option == null || this.option.indexOf(115) == -1) {
            return Eval.calc((String)expStr, arg, this.cs, ctx);
        }
        if (arg == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("eval" + mm.getMessage("function.missingParam"));
        }
        return Eval._$1((String)expStr, arg);
    }

    private static String _$1(String expStr, Sequence arg) {
        int len = expStr.length();
        StringBuffer sb = new StringBuffer(len * 2);
        int q = 0;
        int argCount = arg.length();
        int i = 0;
        while (i < len) {
            char c = expStr.charAt(i);
            if (c == '?') {
                int numEnd = len;
                for (int j = ++i; j < len; ++j) {
                    c = expStr.charAt(j);
                    if (c >= '0' && c <= '9') continue;
                    numEnd = j;
                    break;
                }
                if (numEnd == i) {
                    if (++q > argCount) {
                        q = 1;
                    }
                    Object obj = arg.get(q);
                    String str = Variant.toString(obj);
                    sb.append(str);
                    continue;
                }
                String str = expStr.substring(i, numEnd);
                q = Integer.parseInt(str);
                Object obj = arg.get(q);
                str = Variant.toString(obj);
                sb.append(str);
                i = numEnd;
                continue;
            }
            if (c == '\"' || c == '\'') {
                int index = Sentence.scanQuotation(expStr, i);
                if (index == -1) {
                    sb.append(c);
                    ++i;
                    continue;
                }
                sb.append(expStr.substring(i, ++index));
                i = index;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object calc(String expStr, Sequence arg, ICellSet cs, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        try {
            stack.pushArg(arg);
            Expression exp = new Expression(cs, ctx, expStr);
            Object object = exp.calculate(ctx);
            return object;
        }
        finally {
            stack.popArg();
        }
    }
}

