/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.cellset.ICellSet;
import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;

public class Func
extends Function {
    private Expression _$3;
    private Expression[] _$2;
    private INormalCell _$1;

    public void setParameter(ICellSet cs, Context ctx, String strParam) {
        super.setParameter(cs, ctx, strParam);
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("func" + mm.getMessage("function.missingParam"));
        }
        if (this.option != null && this.option.indexOf(109) != -1) {
            PgmCellSet pcs = (PgmCellSet)cs;
            Expression fnExp = null;
            if (this.param.isLeaf()) {
                fnExp = this.param.getLeafExpression();
            } else {
                IParam sub0 = this.param.getSub(0);
                if (sub0 == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("func" + mm.getMessage("function.invalidParam"));
                }
                fnExp = sub0.getLeafExpression();
                int size = this.param.getSubSize();
                this._$2 = new Expression[size - 1];
                for (int i = 1; i < size; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null) continue;
                    this._$2[i - 1] = sub.getLeafExpression();
                }
            }
            if (!(fnExp.getHome() instanceof CSVariable)) {
                return;
            }
            this._$1 = fnExp.calculateCell(ctx);
            int row = this._$1.getRow();
            int col = this._$1.getCol();
            int endRow = pcs.getCodeBlockEndRow(row, col);
            int colCount = pcs.getColCount();
            for (int r = row; r <= endRow; ++r) {
                for (int c = col + 1; c <= colCount; ++c) {
                    PgmNormalCell cell = pcs.getPgmNormalCell(r, c);
                    if (cell.isBlankCell()) continue;
                    if (this._$3 != null) {
                        this._$3 = null;
                        return;
                    }
                    if (cell.isCommandCell()) {
                        Command cmd = cell.getCommand();
                        if (cmd.getType() == 9) {
                            IParam resultParam = cmd.getParam(pcs, ctx);
                            if (resultParam != null && resultParam.isLeaf()) {
                                this._$3 = resultParam.getLeafExpression();
                                continue;
                            }
                            this._$3 = null;
                            return;
                        }
                        this._$3 = null;
                        return;
                    }
                    if (cell.isCalculableCell()) {
                        this._$3 = cell.getExpression();
                        continue;
                    }
                    this._$3 = null;
                    return;
                }
            }
        }
    }

    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    public Object calculate(Context ctx) {
        if (this._$3 != null) {
            if (this._$2 != null) {
                int paramRow = this._$1.getRow();
                int paramCol = this._$1.getCol();
                int colCount = this.cs.getColCount();
                int pcount = this._$2.length;
                for (int i = 0; i < pcount; ++i) {
                    Object value = this._$2[i].calculate(ctx);
                    this.cs.getCell(paramRow, paramCol).setValue(value);
                    if (paramCol >= colCount) break;
                    ++paramCol;
                }
            }
            return this._$3.calculate(ctx);
        }
        CallInfo callInfo = this.getCallInfo(ctx);
        PgmCellSet pcs = (PgmCellSet)this.cs;
        INormalCell cell = callInfo.getCell();
        Object[] args = callInfo.getArgs();
        if (cell != null) {
            return pcs.executeFunc(cell.getRow(), cell.getCol(), args, this.option);
        }
        return pcs.executeFunc(callInfo.getFnName(), args);
    }

    private CallInfo _$1(Expression exp, Context ctx) {
        if (exp.getHome() instanceof CSVariable) {
            INormalCell cell = exp.calculateCell(ctx);
            return new CallInfo(cell);
        }
        return new CallInfo(exp.toString());
    }

    public CallInfo getCallInfo(Context ctx) {
        CallInfo callInfo;
        if (this.param.isLeaf()) {
            callInfo = this._$1(this.param.getLeafExpression(), ctx);
        } else {
            IParam sub0 = this.param.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("func" + mm.getMessage("function.invalidParam"));
            }
            int size = this.param.getSubSize();
            Object[] args = new Object[size - 1];
            callInfo = this._$1(sub0.getLeafExpression(), ctx);
            callInfo.setArgs(args);
            for (int i = 1; i < size; ++i) {
                IParam sub = this.param.getSub(i);
                if (sub == null) continue;
                args[i - 1] = sub.getLeafExpression().calculate(ctx);
            }
        }
        return callInfo;
    }

    public class CallInfo {
        private INormalCell _$4;
        private String _$3;
        private Object[] _$2;

        public CallInfo(INormalCell cell) {
            this._$4 = cell;
        }

        public CallInfo(String fnName) {
            this._$3 = fnName;
        }

        public PgmCellSet getPgmCellSet() {
            return (PgmCellSet)Func.this.cs;
        }

        public INormalCell getCell() {
            return this._$4;
        }

        public int getRow() {
            return this._$4.getRow();
        }

        public int getCol() {
            return this._$4.getCol();
        }

        public Object[] getArgs() {
            return this._$2;
        }

        public void setArgs(Object[] args) {
            this._$2 = args;
        }

        public String getFnName() {
            return this._$3;
        }
    }
}

