/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Join
extends Function {
    @Override
    public Node optimize(Context ctx) {
        this.param.optimize(ctx);
        return this;
    }

    @Override
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("join" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getType() != ';') {
            MessageManager mm = EngineMessage.get();
            throw new RQException("join" + mm.getMessage("function.invalidParam"));
        }
    }

    @Override
    public Object calculate(Context ctx) {
        boolean isPJoin = false;
        boolean isIsect = false;
        boolean isDiff = false;
        if (this.option != null) {
            if (this.option.indexOf(112) != -1) {
                isPJoin = true;
            } else if (this.option.indexOf(105) != -1) {
                isIsect = true;
            } else if (this.option.indexOf(100) != -1) {
                isDiff = true;
            }
        }
        int count = this.param.getSubSize();
        Sequence[] srcSeries = new Sequence[count];
        String[] names = new String[count];
        Expression[][] exps = new Expression[count][];
        boolean isMix = false;
        for (int i = 0; i < count; ++i) {
            Expression exp;
            Expression[] curExps;
            MessageManager mm;
            IParam seqParam;
            MessageManager mm2;
            IParam sub = this.param.getSub(i);
            if (sub == null) {
                mm2 = EngineMessage.get();
                throw new RQException("join" + mm2.getMessage("function.invalidParam"));
            }
            if (sub.getType() == ',') {
                seqParam = sub.getSub(0);
                if (seqParam == null) {
                    mm2 = EngineMessage.get();
                    throw new RQException("join" + mm2.getMessage("function.invalidParam"));
                }
                int expCount = sub.getSubSize() - 1;
                if (!isPJoin && i != 0 && expCount != exps[0].length) {
                    if (expCount > exps[0].length) {
                        mm = EngineMessage.get();
                        throw new RQException("join" + mm.getMessage("function.paramCountNotMatch"));
                    }
                    isMix = true;
                }
                curExps = new Expression[expCount];
                exps[i] = curExps;
                for (int p = 0; p < expCount; ++p) {
                    IParam expParam = sub.getSub(p + 1);
                    if (expParam == null) {
                        if (i == 0) {
                            MessageManager mm3 = EngineMessage.get();
                            throw new RQException("join" + mm3.getMessage("function.invalidParam"));
                        }
                        isMix = true;
                        continue;
                    }
                    curExps[p] = expParam.getLeafExpression();
                }
            } else {
                seqParam = sub;
                if (!isPJoin) {
                    exp = new Expression("~.v()");
                    curExps = new Expression[]{exp};
                    exps[i] = curExps;
                    if (i != 0 && exps[0].length > 1) {
                        isMix = true;
                    }
                }
            }
            if (seqParam.isLeaf()) {
                exp = seqParam.getLeafExpression();
                names[i] = exp.getIdentifierName();
                Object obj = exp.calculate(ctx);
                if (obj instanceof Sequence) {
                    srcSeries[i] = (Sequence)obj;
                    continue;
                }
                if (obj == null) {
                    srcSeries[i] = new Sequence(0);
                    continue;
                }
                MessageManager mm4 = EngineMessage.get();
                throw new RQException("join" + mm4.getMessage("function.paramTypeError"));
            }
            if (seqParam.getSubSize() != 2) {
                MessageManager mm5 = EngineMessage.get();
                throw new RQException("join" + mm5.getMessage("function.invalidParam"));
            }
            IParam sub0 = seqParam.getSub(0);
            if (sub0 == null) {
                mm = EngineMessage.get();
                throw new RQException("join" + mm.getMessage("function.invalidParam"));
            }
            Expression exp2 = sub0.getLeafExpression();
            Object obj = exp2.calculate(ctx);
            if (obj instanceof Sequence) {
                srcSeries[i] = (Sequence)obj;
            } else if (obj == null) {
                srcSeries[i] = new Sequence(0);
            } else {
                MessageManager mm6 = EngineMessage.get();
                throw new RQException("join" + mm6.getMessage("function.paramTypeError"));
            }
            IParam sub1 = seqParam.getSub(1);
            names[i] = sub1 != null ? sub1.getLeafExpression().getIdentifierName() : exp2.getIdentifierName();
        }
        if (isPJoin) {
            return Sequence.pjoin(srcSeries, names, this.option);
        }
        if (isIsect || isDiff) {
            return CursorUtil.filterJoin(srcSeries, exps, this.option, ctx);
        }
        if (isMix) {
            int type = 0;
            if (this.option != null) {
                if (this.option.indexOf(49) != -1) {
                    type = 1;
                    if (this.option.indexOf(102) != -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(this.option + mm.getMessage("engine.optConflict"));
                    }
                } else if (this.option.indexOf(102) != -1) {
                    type = 2;
                }
            }
            return CursorUtil.mixJoin(srcSeries, exps, names, type, ctx);
        }
        Table result = Sequence.join(srcSeries, exps, names, this.option, ctx);
        return this._$1(srcSeries, result, names);
    }

    private Sequence _$1(Sequence[] srcSeries, Sequence table, String[] names) {
        int count;
        if (this.option == null || this.option.indexOf(120) == -1 || table == null) {
            return table;
        }
        IArray mems = table.getMems();
        int size = mems.size();
        if (size == 0) {
            return table;
        }
        int newCount = count = names.length;
        boolean hasAllRecord = false;
        boolean[] isAllRecord = new boolean[count];
        int[] fcount = new int[count];
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            fcount[i] = srcSeries[i].dataStruct().getFieldCount();
            isAllRecord[i] = true;
            for (int j = 0; j < fcount[i]; ++j) {
                boolean b = this._$1(mems, i, j, list, names);
                if (b) continue;
                isAllRecord[i] = false;
                break;
            }
            if (!isAllRecord[i]) continue;
            newCount += fcount[i] - 1;
            hasAllRecord = true;
        }
        if (!hasAllRecord) {
            return table;
        }
        String[] newNames = new String[newCount];
        list.toArray(newNames);
        int findex = 0;
        Table out = new Table(newNames);
        for (int i = 1; i <= size; ++i) {
            findex = 0;
            BaseRecord record = out.newLast();
            BaseRecord oldRecord = (BaseRecord)mems.get(i);
            for (int j = 0; j < count; ++j) {
                if (isAllRecord[j]) {
                    BaseRecord subRecord = (BaseRecord)oldRecord.getFieldValue(j);
                    for (int f = 0; f < fcount[j]; ++f) {
                        record.set(findex + f, subRecord.getFieldValue(f));
                    }
                    findex += fcount[j];
                    continue;
                }
                record.set(findex, oldRecord.getFieldValue(j));
                ++findex;
            }
        }
        return out;
    }

    private boolean _$1(IArray mems, int i, int j, ArrayList<String> list, String[] names) {
        int c;
        boolean b = true;
        int size = mems.size();
        for (c = 1; c <= size; ++c) {
            Object obj;
            BaseRecord record = (BaseRecord)mems.get(c);
            if (null == record || null == (record = (BaseRecord)record.getFieldValue(i)) || (obj = record.getFieldValue(j)) == null) continue;
            if (obj instanceof BaseRecord) {
                String name = record.getFieldNames()[j];
                if (list.contains(name)) {
                    list.add(names[i] + "_" + name);
                    break;
                }
                list.add(name);
                break;
            }
            b = false;
            break;
        }
        if (!b) {
            list.add(names[i]);
        }
        if (c > size) {
            list.add(names[i] + "_" + j);
        }
        return b;
    }
}

