/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.JobSpace;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.resources.EngineMessage;
import com.scudata.vdb.Library;
import com.scudata.vdb.VDB;
import java.io.File;

public class VDBase
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("vdbase" + mm.getMessage("function.missingParam"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object calculate(Context ctx) {
        JobSpace js;
        String pathName;
        if (this.option != null && this.option.indexOf(114) != -1) {
            String pathName1;
            String pathName0;
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("vdbase" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("vdbase" + mm.getMessage("function.invalidParam"));
            }
            Object p0 = sub0.getLeafExpression().calculate(ctx);
            if (p0 instanceof String) {
                pathName0 = (String)p0;
            } else {
                if (!(p0 instanceof FileObject)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("vdbase" + mm.getMessage("function.paramTypeError"));
                }
                pathName0 = ((FileObject)p0).getFileName();
            }
            Object p1 = sub1.getLeafExpression().calculate(ctx);
            if (p1 instanceof String) {
                pathName1 = (String)p1;
            } else {
                if (!(p1 instanceof FileObject)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("vdbase" + mm.getMessage("function.paramTypeError"));
                }
                pathName1 = ((FileObject)p1).getFileName();
            }
            JobSpace js2 = ctx.getJobSpace();
            if (js2 != null && js2.getAppHome() != null) {
                File file = new File(js2.getAppHome(), pathName0);
                pathName0 = file.getAbsolutePath();
                file = new File(js2.getAppHome(), pathName1);
                pathName1 = file.getAbsolutePath();
            }
            Library library = new Library(pathName0);
            library.start();
            boolean result = library.reset(pathName1);
            library.stop();
            return result;
        }
        Object[] keys = null;
        int[] lens = null;
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (obj instanceof String) {
                pathName = (String)obj;
            } else {
                if (!(obj instanceof FileObject)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("vdbase" + mm.getMessage("function.paramTypeError"));
                }
                pathName = ((FileObject)obj).getFileName();
            }
        } else {
            if (this.param.getType() != ';') {
                MessageManager mm = EngineMessage.get();
                throw new RQException("vdbase" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null || this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("vdbase" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub0.getLeafExpression().calculate(ctx);
            if (obj instanceof String) {
                pathName = (String)obj;
            } else {
                if (!(obj instanceof FileObject)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("vdbase" + mm.getMessage("function.paramTypeError"));
                }
                pathName = ((FileObject)obj).getFileName();
            }
            ParamInfo2 pi = ParamInfo2.parse(sub1, "vdbase", true, true);
            keys = pi.getValues1(ctx);
            Object[] nums = pi.getValues2(ctx);
            int len = nums.length;
            lens = new int[len];
            for (int i = 0; i < len; ++i) {
                if (!(nums[i] instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("vdbase" + mm.getMessage("function.paramTypeError"));
                }
                lens[i] = ((Number)nums[i]).intValue();
                if (lens[i] >= 2) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("vdbase" + mm.getMessage("function.invalidParam"));
            }
        }
        if ((js = ctx.getJobSpace()) != null && js.getAppHome() != null) {
            File file = new File(js.getAppHome(), pathName);
            pathName = file.getAbsolutePath();
        }
        Library library = Library.instance(pathName);
        if (keys != null) {
            library.createKeyLibrary(keys, lens);
        }
        VDB vdb = library.createVDB();
        ctx.addResource(vdb);
        return vdb;
    }

    public byte calcExpValueType(Context ctx) {
        return 1;
    }

    public Node optimize(Context ctx) {
        return this;
    }
}

