/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.fn.algebra.Matrix;
import com.scudata.resources.EngineMessage;

public class Distance
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("dis" + mm.getMessage("function.missingParam"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object calculate(Context ctx) {
        MessageManager mm;
        Object o11;
        boolean manhattan = false;
        boolean standard = false;
        if (this.option != null) {
            if (this.option.indexOf(97) > -1) {
                manhattan = true;
            }
            if (this.option.indexOf(109) > -1) {
                standard = true;
            }
        }
        Sequence s1 = null;
        Sequence s2 = null;
        if (this.param.isLeaf()) {
            Object o = this.param.getLeafExpression().calculate(ctx);
            if (!(o instanceof Sequence)) {
                MessageManager mm2 = EngineMessage.get();
                throw new RQException("dis" + mm2.getMessage("function.paramTypeError"));
            }
            s1 = (Sequence)o;
        } else {
            if (this.param.getSubSize() != 2) {
                MessageManager mm3 = EngineMessage.get();
                throw new RQException("dis" + mm3.getMessage("function.invalidParam"));
            }
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm4 = EngineMessage.get();
                throw new RQException("dis" + mm4.getMessage("function.invalidParam"));
            }
            Object o1 = sub1.getLeafExpression().calculate(ctx);
            Object o2 = sub2.getLeafExpression().calculate(ctx);
            if (o1 instanceof Sequence && o2 instanceof Sequence) {
                s1 = (Sequence)o1;
                s2 = (Sequence)o2;
            }
        }
        if (s1 == null) {
            MessageManager mm5 = EngineMessage.get();
            throw new RQException("dis" + mm5.getMessage("function.paramTypeError"));
        }
        Matrix A = new Matrix(s1);
        Object object = o11 = s1.length() > 0 ? s1.get(1) : null;
        if (!(o11 instanceof Sequence)) {
            A = A.transpose();
        }
        Matrix B = null;
        if (s2 != null) {
            Object o21;
            B = new Matrix(s2);
            Object object2 = o21 = s2.length() > 0 ? s2.get(1) : null;
            if (!(o21 instanceof Sequence)) {
                B = B.transpose();
            }
        } else {
            double[][] bs = new double[1][A.getCols()];
            B = new Matrix(bs);
        }
        if (A.getCols() == 0 && A.getRows() == 0) {
            mm = EngineMessage.get();
            throw new RQException("dis" + mm.getMessage("function.paramTypeError"));
        }
        if (B.getCols() == 0 && B.getRows() == 0) {
            mm = EngineMessage.get();
            throw new RQException("dis" + mm.getMessage("function.paramTypeError"));
        }
        Matrix X = new Matrix(A.getRows(), B.getRows());
        double[][] xs = X.getArray();
        int r = 0;
        block0: while (r < A.getRows()) {
            int c = 0;
            while (true) {
                double res;
                if (c < B.getRows()) {
                    res = 0.0;
                } else {
                    ++r;
                    continue block0;
                }
                for (int i = 0; i < A.getCols(); ++i) {
                    if (manhattan) {
                        res += Math.abs(A.get(r, i) - B.get(c, i));
                        continue;
                    }
                    res += Math.pow(A.get(r, i) - B.get(c, i), 2.0);
                }
                if (standard) {
                    res /= (double)A.getCols();
                }
                xs[r][c] = manhattan ? res : Math.sqrt(res);
                ++c;
            }
            break;
        }
        return X.toSequence(this.option, false);
    }
}

