/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamParser;
import com.scudata.expression.fn.algebra.Matrix;
import com.scudata.resources.EngineMessage;

public class Linefit
extends Function {
    private static final double _$2 = 1000000.0;
    private static final double _$1 = 1.0E-14;

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("linefit" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("linefit" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        boolean ifVector;
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("linefit" + mm.getMessage("function.invalidParam"));
        }
        Object o1 = sub1.getLeafExpression().calculate(ctx);
        Object o2 = sub2.getLeafExpression().calculate(ctx);
        boolean bl = ifVector = this.option != null && this.option.indexOf(49) > -1;
        if (o1 instanceof Sequence && o2 instanceof Sequence) {
            double[][] vs;
            int rows;
            boolean oneline;
            Matrix A = new Matrix((Sequence)o1);
            Matrix B = new Matrix((Sequence)o2);
            boolean bl2 = oneline = B.getRows() == 1;
            if (oneline) {
                B = B.transpose();
            } else if (ifVector && !(((Sequence)o2).get(1) instanceof Sequence)) {
                oneline = true;
            }
            if (A.getCols() == 0 || A.getRows() == 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("linefit" + mm.getMessage("function.paramTypeError"));
            }
            if (B.getCols() == 0 || B.getRows() == 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("linefit" + mm.getMessage("function.paramTypeError"));
            }
            Matrix X = A.solve(B);
            if (X == null) {
                return null;
            }
            if (oneline && (rows = (vs = X.getArray()).length) > 0) {
                int cols = vs[0].length;
                if (cols == 1) {
                    Sequence result = new Sequence(rows);
                    for (int i = 0; i < rows; ++i) {
                        result.add(Linefit.getValue(vs[i][0]));
                    }
                    return result;
                }
                if (rows == 1) {
                    Sequence result = new Sequence(cols);
                    for (int i = 0; i < cols; ++i) {
                        result.add(Linefit.getValue(vs[0][i]));
                    }
                    return result;
                }
            }
            return X.toSequence(this.option, false);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("linefit" + mm.getMessage("function.paramTypeError"));
    }

    public static void main(String[] args) {
        IParam params;
        Linefit func = new Linefit();
        double[][] h_A = new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 3.0, 1.0, 2.0}, {1.0, 1.0, 1.0, -1.0}, {1.0, 0.0, -2.0, -6.0}};
        double[] h_B = new double[]{4.0, 6.0, 2.0, 4.0};
        Sequence A = Linefit.toSeq(h_A);
        Sequence B = Linefit.toSeq(h_B, h_B.length);
        Context ctx = new Context();
        ctx.setParamValue("A", A);
        ctx.setParamValue("B", B);
        func.option = "1";
        func.param = params = ParamParser.parse("A,B", null, ctx);
        Object res = func.calculate(ctx);
        Linefit.print((Sequence)res, 10);
    }

    protected static Sequence toSeq(double[][] C) {
        int rows = C.length;
        Sequence seq = new Sequence(rows);
        for (int i = 0; i < rows; ++i) {
            double[] sub = C[i];
            int cols = sub.length;
            seq.add(Linefit.toSeq(sub, cols));
        }
        return seq;
    }

    protected static Sequence toSeq(double[] C, int size) {
        Sequence seq = new Sequence(size);
        for (int i = 0; i < size; ++i) {
            seq.add(C[i]);
        }
        return seq;
    }

    protected static void print(Sequence seq, int n) {
        int len = seq.length();
        if (len > n) {
            len = n;
        }
        for (int c = 1; c <= len; ++c) {
            Object o = seq.get(c);
            if (o instanceof Sequence) {
                Linefit.print((Sequence)o);
                continue;
            }
            if (o instanceof Number) {
                System.out.printf("%2.6f ", ((Number)o).doubleValue());
                System.out.print("  ");
                continue;
            }
            if (o != null) {
                System.out.print(o.toString());
                continue;
            }
            System.out.printf("%2.6f ", "");
            System.out.print("  ");
        }
        System.out.println();
    }

    protected static void print(Sequence seq) {
        int len = seq.length();
        for (int c = 1; c <= len; ++c) {
            Object o = seq.get(c);
            if (o instanceof Sequence) {
                Linefit.print((Sequence)o);
                continue;
            }
            if (o instanceof Number) {
                System.out.printf("%2.6f ", ((Number)o).doubleValue());
                System.out.print("  ");
                continue;
            }
            if (o != null) {
                System.out.print(o.toString());
                continue;
            }
            System.out.printf("%2.6f ", "");
            System.out.print("  ");
        }
        System.out.println();
    }

    protected static double getValue(double d) {
        double d1;
        double abs = Math.abs(d);
        double scale1 = 1000000.0;
        if (abs < 1.0E-14) {
            return d;
        }
        if (abs < 1.0) {
            scale1 *= Math.pow(10.0, (int)Math.round(Math.log10(1.0 / abs)));
        }
        if ((d1 = d * scale1) > -9.223372036854776E18 && d1 < 9.223372036854776E18) {
            d = (double)Math.round(d1) / scale1;
        }
        return d;
    }
}

