/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.fn.algebra.Matrix;
import com.scudata.resources.EngineMessage;

public class Mul
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("mul" + mm.getMessage("function.missingParam"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object calculate(Context ctx) {
        boolean ifvb;
        if (this.param.isLeaf()) {
            Object o = this.param.getLeafExpression().calculate(ctx);
            if (o instanceof Sequence) {
                return o;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("mul" + mm.getMessage("function.paramTypeError"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("mul" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("mul" + mm.getMessage("function.invalidParam"));
        }
        Object o1 = sub1.getLeafExpression().calculate(ctx);
        Object o2 = sub2.getLeafExpression().calculate(ctx);
        boolean ifva = o1 instanceof Sequence && ((Sequence)o1).length() > 0 && ((Sequence)o1).get(1) instanceof Number;
        boolean bl = ifvb = o2 instanceof Sequence && ((Sequence)o2).length() > 0 && ((Sequence)o2).get(1) instanceof Number;
        if (ifvb) {
            String string = this.option = this.option == null ? "v" : this.option + "v";
        }
        if (o1 instanceof Sequence && o2 instanceof Sequence) {
            Matrix A = new Matrix((Sequence)o1);
            Matrix B = new Matrix((Sequence)o2);
            if (A.getCols() == 0 || A.getRows() == 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("mul" + mm.getMessage("function.paramTypeError"));
            }
            if (B.getCols() == 0 || B.getRows() == 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("mul" + mm.getMessage("function.paramTypeError"));
            }
            if (ifva && ifvb && A.getCols() != B.getCols()) {
                A = A.transpose();
            } else if (A.getCols() != B.getRows() && ifvb) {
                B = B.transpose();
            }
            Matrix X = A.times(B);
            if (X == null) {
                return null;
            }
            return X.toSequence(this.option, false);
        }
        if (!(o1 instanceof Sequence) && !(o2 instanceof Sequence)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("mul" + mm.getMessage("function.paramTypeError"));
        }
        Sequence seq = null;
        double mul = 1.0;
        if (o1 instanceof Sequence) {
            if (ifva) {
                this.option = this.option == null ? "v" : this.option + "v";
            }
            seq = (Sequence)o1;
            if (!(o2 instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("mul" + mm.getMessage("function.paramTypeError"));
            }
            mul = ((Number)o2).doubleValue();
        } else {
            seq = (Sequence)o2;
            if (!(o1 instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("mul" + mm.getMessage("function.paramTypeError"));
            }
            mul = ((Number)o1).doubleValue();
        }
        Matrix A = new Matrix(seq);
        double[][] vs = A.getArray();
        int rows = vs.length;
        int cols = A.getCols();
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                double[] dArray = vs[r];
                int n = c++;
                dArray[n] = dArray[n] * mul;
            }
            ++r;
        }
        return A.toSequence(this.option, false);
    }
}

