/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamParser;
import com.scudata.expression.fn.algebra.Linefit;
import com.scudata.expression.fn.algebra.Matrix;
import com.scudata.resources.EngineMessage;

public class Polyfit
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("polyfit" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("polyfit" + mm.getMessage("function.invalidParam"));
        }
        if (this.param.getSubSize() != 3) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("polyfit" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        IParam sub3 = this.param.getSub(2);
        if (sub1 == null || sub2 == null || sub3 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("polyfit" + mm.getMessage("function.invalidParam"));
        }
        Object o1 = sub1.getLeafExpression().calculate(ctx);
        Object o2 = sub2.getLeafExpression().calculate(ctx);
        Object o3 = sub3.getLeafExpression().calculate(ctx);
        if (o1 instanceof Sequence && o2 instanceof Sequence && o3 instanceof Number) {
            int n = ((Number)o3).intValue();
            if (n < 1) {
                n = 1;
            }
            Sequence A = (Sequence)o1;
            Sequence B = (Sequence)o2;
            int size = A.length();
            if (size != B.length()) {
                MessageManager mm = EngineMessage.get();
                Logger.warn("polyfit" + mm.getMessage("function.paramTypeError"));
                return null;
            }
            double[] as = new double[size];
            double[] bs = new double[size];
            for (int i = 1; i <= size; ++i) {
                Object o = A.get(i);
                if (o instanceof Number) {
                    as[i - 1] = ((Number)o).doubleValue();
                }
                if (!((o = B.get(i)) instanceof Number)) continue;
                bs[i - 1] = ((Number)o).doubleValue();
            }
            Matrix P = new Matrix(n + 1, n + 1);
            double[][] ps = P.getArray();
            Matrix Y = new Matrix(n + 1, 1);
            double[][] ys = Y.getArray();
            for (int i = 0; i < n + 1; ++i) {
                for (int j = 0; j < n + 1; ++j) {
                    if (i > j) {
                        ps[i][j] = ps[j][i];
                        continue;
                    }
                    double p = 0.0;
                    for (int k = 0; k < size; ++k) {
                        p += Math.pow(as[k], i + j);
                    }
                    ps[i][j] = p;
                }
                double p = 0.0;
                for (int k = 0; k < size; ++k) {
                    p += Math.pow(as[k], i) * bs[k];
                }
                ys[i][0] = p;
            }
            Matrix X = P.solve(Y);
            if (X == null) {
                return null;
            }
            double[][] vs = X.getArray();
            int rows = vs.length;
            if (rows > 0) {
                int cols = vs[0].length;
                if (cols == 1) {
                    Sequence result = new Sequence(rows);
                    for (int i = 0; i < rows; ++i) {
                        result.add(Linefit.getValue(vs[i][0]));
                    }
                    return result;
                }
                if (rows == 1) {
                    Sequence result = new Sequence(cols);
                    for (int i = 0; i < cols; ++i) {
                        result.add(Linefit.getValue(vs[0][i]));
                    }
                    return result;
                }
            }
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("polyfit" + mm.getMessage("function.paramTypeError"));
    }

    public static void main(String[] args) {
        IParam params;
        Polyfit func = new Polyfit();
        double[] h_A = new double[]{3.0, 5.0, 2.0, 8.0};
        double[] h_B = new double[]{4.0, 6.0, 2.0, 4.0};
        Sequence A = Linefit.toSeq(h_A, h_A.length);
        Sequence B = Linefit.toSeq(h_B, h_B.length);
        Context ctx = new Context();
        ctx.setParamValue("A", A);
        ctx.setParamValue("B", B);
        func.option = "1";
        func.param = params = ParamParser.parse("A,B,2", null, ctx);
        Object res = func.calculate(ctx);
        Linefit.print((Sequence)res, 10);
    }
}

