/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.expression.fn.algebra.Matrix;

public class QRDecomposition {
    private double[][] _$4;
    private int _$3;
    private int _$2;
    private double[] _$1;

    protected QRDecomposition(Matrix A) {
        this._$4 = A.getArrayCopy();
        this._$3 = A.getRows();
        this._$2 = A.getCols();
        this._$1 = new double[this._$2];
        for (int k = 0; k < this._$2; ++k) {
            int r;
            double nrm = 0.0;
            for (r = k; r < this._$3; ++r) {
                nrm = Math.hypot(nrm, this._$4[r][k]);
            }
            if (nrm != 0.0) {
                if (this._$4[k][k] < 0.0) {
                    nrm = -nrm;
                }
                for (r = k; r < this._$3; ++r) {
                    double[] dArray = this._$4[r];
                    int n = k;
                    dArray[n] = dArray[n] / nrm;
                }
                double[] dArray = this._$4[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                for (int c = k + 1; c < this._$2; ++c) {
                    int r2;
                    double s = 0.0;
                    for (r2 = k; r2 < this._$3; ++r2) {
                        s += this._$4[r2][k] * this._$4[r2][c];
                    }
                    s = -s / this._$4[k][k];
                    for (r2 = k; r2 < this._$3; ++r2) {
                        double[] dArray2 = this._$4[r2];
                        int n2 = c;
                        dArray2[n2] = dArray2[n2] + s * this._$4[r2][k];
                    }
                }
            }
            this._$1[k] = -nrm;
        }
    }

    protected boolean isFullRank() {
        for (int c = 0; c < this._$2; ++c) {
            if (!Matrix.ifZero(this._$1[c])) continue;
            return false;
        }
        return true;
    }

    protected Matrix solve(Matrix B) {
        int c;
        int k;
        if (B.getRows() != this._$3) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = B.getCols();
        double[][] X = B.getArrayCopy();
        for (k = 0; k < this._$2; ++k) {
            for (c = 0; c < nx; ++c) {
                int r;
                double s = 0.0;
                for (r = k; r < this._$3; ++r) {
                    s += this._$4[r][k] * X[r][c];
                }
                s = -s / this._$4[k][k];
                for (r = k; r < this._$3; ++r) {
                    double[] dArray = X[r];
                    int n = c;
                    dArray[n] = dArray[n] + s * this._$4[r][k];
                }
            }
        }
        for (k = this._$2 - 1; k >= 0; --k) {
            c = 0;
            while (c < nx) {
                double[] dArray = X[k];
                int n = c++;
                dArray[n] = dArray[n] / this._$1[k];
            }
            for (int r = 0; r < k; ++r) {
                for (int c2 = 0; c2 < nx; ++c2) {
                    double[] dArray = X[r];
                    int n = c2;
                    dArray[n] = dArray[n] - X[k][c2] * this._$4[r][k];
                }
            }
        }
        return new Matrix(X, this._$2, nx).getMatrix(0, this._$2 - 1, 0, nx - 1);
    }
}

