/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.algebra;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;

public class Spearman
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("spearman" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object o1 = null;
        Sequence o2 = null;
        if (this.param.isLeaf()) {
            o1 = this.param.getLeafExpression().calculate(ctx);
            if (!(o1 instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("spearman" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("spearman" + mm.getMessage("function.invalidParam"));
            }
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("spearman" + mm.getMessage("function.invalidParam"));
            }
            o1 = sub1.getLeafExpression().calculate(ctx);
            Sequence sequence = o2 = sub2 == null ? null : sub2.getLeafExpression().calculate(ctx);
        }
        if (o2 == null) {
            int len = o1 instanceof Sequence ? ((Sequence)o1).length() : 1;
            o2 = new Sequence(1, len);
        }
        if (o1 instanceof Sequence && o2 instanceof Sequence) {
            return Spearman.spearman((Sequence)o1, o2);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("spearman" + mm.getMessage("function.paramTypeError"));
    }

    public static double spearman(Sequence x, Sequence y) {
        double n = x.length();
        Sequence p = x.ranks("s");
        Sequence q = y.ranks("s");
        Sequence d = p.memberSubtract(q);
        double sumup = 0.0;
        int i = 1;
        while ((double)i <= n) {
            double dcur = ((Number)d.get(i)).doubleValue();
            sumup += dcur * dcur;
            ++i;
        }
        return 1.0 - 6.0 * sumup / n / (n * n - 1.0);
    }
}

