/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import com.scudata.util.JSONUtil;

public class Json
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("json" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("json" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object val = this.param.getLeafExpression().calculate(ctx);
        if (val instanceof String) {
            if (this.option == null || this.option.indexOf(118) == -1) {
                char[] chars = ((String)val).toCharArray();
                return JSONUtil.parseJSON(chars, 0, chars.length - 1, this.option);
            }
            Expression exp = new Expression(this.cs, ctx, (String)val);
            return exp.calculate(ctx);
        }
        if (val instanceof Sequence) {
            return JSONUtil.toJSON((Sequence)val);
        }
        if (val instanceof BaseRecord) {
            return JSONUtil.toJSON((BaseRecord)val);
        }
        if (val == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("json" + mm.getMessage("function.paramTypeError"));
    }
}

