/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.array.IArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.math.BigDecimal;

public class ToBigDecimal
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("decimal" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("decimal" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object result = this.param.getLeafExpression().calculate(ctx);
        if (result instanceof String) {
            try {
                return new BigDecimal((String)result);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (result == null) {
            return null;
        }
        return Variant.toBigDecimal(result);
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int len = array.size();
        Object[] resultValues = new Object[len + 1];
        if (array instanceof LongArray) {
            LongArray longArray = (LongArray)array;
            for (int i = 1; i <= len; ++i) {
                resultValues[i] = new BigDecimal(longArray.getLong(i));
            }
        } else if (array instanceof NumberArray) {
            NumberArray numberArray = (NumberArray)array;
            for (int i = 1; i <= len; ++i) {
                resultValues[i] = new BigDecimal(numberArray.getDouble(i));
            }
        } else {
            try {
                for (int i = 1; i <= len; ++i) {
                    Object obj = array.get(i);
                    if (obj instanceof String) {
                        resultValues[i] = new BigDecimal((String)obj);
                        continue;
                    }
                    if (obj == null) continue;
                    resultValues[i] = Variant.toBigDecimal(obj);
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        ObjectArray result = new ObjectArray(resultValues, len);
        result.setTemporary(true);
        return result;
    }
}

