/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.array.ObjectArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class ToBool
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("bool" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("bool" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object obj = this.param.getLeafExpression().calculate(ctx);
        if (obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof String) {
            if (((String)obj).equals("false")) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (obj == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        if (array instanceof StringArray) {
            int len = array.size();
            StringArray strArray = (StringArray)array;
            boolean[] values = new boolean[len + 1];
            for (int i = 1; i <= len; ++i) {
                String str = strArray.getString(i);
                values[i] = str != null && !str.equals("false");
            }
            BoolArray result = new BoolArray(values, len);
            result.setTemporary(true);
            return result;
        }
        if (array instanceof ObjectArray) {
            int len = array.size();
            boolean[] values = new boolean[len + 1];
            for (int i = 1; i <= len; ++i) {
                Object obj = array.get(i);
                values[i] = obj instanceof Boolean ? (Boolean)obj : (obj instanceof String ? obj != null && !obj.equals("false") : obj != null);
            }
            BoolArray result = new BoolArray(values, len);
            result.setTemporary(true);
            return result;
        }
        return array.isTrue();
    }
}

