/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.array.IArray;
import com.scudata.array.NumberArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class ToChar
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("char" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("char" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object result = this.param.getLeafExpression().calculate(ctx);
        if (result instanceof Number) {
            char[] c = new char[]{(char)((Number)result).intValue()};
            return new String(c);
        }
        if (result == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("char" + mm.getMessage("function.paramTypeError"));
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int len = array.size();
        String[] resultValues = new String[len + 1];
        char[] chars = new char[1];
        if (array instanceof NumberArray) {
            NumberArray numberArray = (NumberArray)array;
            for (int i = 1; i <= len; ++i) {
                if (array.isNull(i)) continue;
                chars[0] = (char)numberArray.getInt(i);
                resultValues[i] = new String(chars);
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                Object obj = array.get(i);
                if (obj instanceof Number) {
                    chars[0] = (char)((Number)obj).intValue();
                    resultValues[i] = new String(chars);
                    continue;
                }
                if (obj == null) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("char" + mm.getMessage("function.paramTypeError"));
            }
        }
        StringArray result = new StringArray(resultValues, len);
        result.setTemporary(true);
        return result;
    }
}

