/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.array.IArray;
import com.scudata.array.NumberArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class ToChinese
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("chn" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("chn" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object result = this.param.getLeafExpression().calculate(ctx);
        if (result instanceof Number) {
            boolean abbreviate = false;
            boolean uppercase = false;
            boolean rmb = false;
            if (this.option != null) {
                if (this.option.indexOf(97) != -1) {
                    abbreviate = true;
                }
                if (this.option.indexOf(117) != -1) {
                    uppercase = true;
                }
                if (this.option.indexOf(98) != -1) {
                    rmb = true;
                }
            }
            if (rmb) {
                double d = ((Number)result).doubleValue();
                return StringUtils.toRMB(d, abbreviate, uppercase);
            }
            long l = ((Number)result).longValue();
            return StringUtils.toChinese(l, abbreviate, uppercase);
        }
        if (result == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("chn" + mm.getMessage("function.paramTypeError"));
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int len = array.size();
        String[] resultValues = new String[len + 1];
        boolean abbreviate = false;
        boolean uppercase = false;
        boolean rmb = false;
        if (this.option != null) {
            if (this.option.indexOf(97) != -1) {
                abbreviate = true;
            }
            if (this.option.indexOf(117) != -1) {
                uppercase = true;
            }
            if (this.option.indexOf(98) != -1) {
                rmb = true;
            }
        }
        if (array instanceof NumberArray) {
            NumberArray numberArray = (NumberArray)array;
            for (int i = 1; i <= len; ++i) {
                if (array.isNull(i)) continue;
                if (rmb) {
                    double d = numberArray.getDouble(i);
                    resultValues[i] = StringUtils.toRMB(d, abbreviate, uppercase);
                    continue;
                }
                long l = numberArray.getLong(i);
                resultValues[i] = StringUtils.toChinese(l, abbreviate, uppercase);
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                Object obj = array.get(i);
                if (obj instanceof Number) {
                    if (rmb) {
                        double d = ((Number)obj).doubleValue();
                        resultValues[i] = StringUtils.toRMB(d, abbreviate, uppercase);
                        continue;
                    }
                    long l = ((Number)obj).longValue();
                    resultValues[i] = StringUtils.toChinese(l, abbreviate, uppercase);
                    continue;
                }
                if (obj == null) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("chn" + mm.getMessage("function.paramTypeError"));
            }
        }
        StringArray result = new StringArray(resultValues, len);
        result.setTemporary(true);
        return result;
    }
}

