/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.NumberArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class ToDouble
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("float" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("float" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object result = this.param.getLeafExpression().calculate(ctx);
        if (result instanceof Double) {
            return result;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        if (result instanceof String) {
            try {
                return new Double((String)result);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (result == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("float" + mm.getMessage("function.paramTypeError"));
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        if (array instanceof DoubleArray) {
            return array;
        }
        int len = array.size();
        DoubleArray result = new DoubleArray(len);
        result.setTemporary(true);
        if (array instanceof NumberArray) {
            NumberArray numberArray = (NumberArray)array;
            for (int i = 1; i <= len; ++i) {
                if (numberArray.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                result.pushDouble(numberArray.getDouble(i));
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                Object obj = array.get(i);
                if (obj instanceof Number) {
                    result.pushDouble(((Number)obj).doubleValue());
                    continue;
                }
                if (obj instanceof String) {
                    result.pushDouble(Double.parseDouble((String)obj));
                    continue;
                }
                if (obj == null) {
                    result.pushNull();
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("float" + mm.getMessage("function.paramTypeError"));
            }
        }
        return result;
    }
}

