/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.ibm.icu.text.DecimalFormat;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class ToNumber
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("number" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object result = this.param.getLeafExpression().calculate(ctx);
            if (result instanceof String) {
                return Variant.parseNumber((String)result);
            }
            if (result instanceof Number) {
                return result;
            }
            return null;
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("number" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("number" + mm.getMessage("function.invalidParam"));
        }
        Object result1 = sub1.getLeafExpression().calculate(ctx);
        Object result2 = sub2.getLeafExpression().calculate(ctx);
        if (result1 instanceof String) {
            Object result;
            if (result2 instanceof String) {
                try {
                    DecimalFormat nf = new DecimalFormat((String)result2);
                    nf.setRoundingMode(4);
                    return nf.parse((String)result1);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((result = Variant.parse((String)result1)) instanceof Number) {
                return result;
            }
        } else if (result1 instanceof Number) {
            return result1;
        }
        if (result2 instanceof Number) {
            return result2;
        }
        return null;
    }
}

