/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.convert;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.XMLUtil;

public class Xml
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xml" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object val;
        String s = null;
        if (this.param.isLeaf()) {
            val = this.param.getLeafExpression().calculate(ctx);
        } else if (this.param.getSubSize() == 2) {
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xml" + mm.getMessage("function.invalidParam"));
            }
            val = sub0.getLeafExpression().calculate(ctx);
            Object obj = sub1.getLeafExpression().calculate(ctx);
            if (obj instanceof String) {
                s = (String)obj;
            } else if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xml" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xml" + mm.getMessage("function.invalidParam"));
        }
        if (val instanceof String) {
            return XMLUtil.parseXml((String)val, s, this.option);
        }
        if (val instanceof Sequence) {
            return XMLUtil.toXml((Sequence)val, null, s);
        }
        if (val instanceof BaseRecord) {
            return XMLUtil.toXml((BaseRecord)val, null, s);
        }
        if (val == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("xml" + mm.getMessage("function.paramTypeError"));
    }
}

