/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.common.DateFactory;
import com.scudata.common.DateFormatFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class Age
extends Function {
    public Node optimize(Context ctx) {
        this.param.optimize(ctx);
        return this;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("age" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        Date date;
        Date now = null;
        if (this.param.getType() == ',') {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("age" + mm.getMessage("function.invalidParam"));
            }
            IParam sub = this.param.getSub(0);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("age" + mm.getMessage("function.invalidParam"));
            }
            date = Age._$1(sub, ctx);
            if (date == null) {
                return null;
            }
            sub = this.param.getSub(1);
            if (sub != null) {
                now = Age._$1(sub, ctx);
            }
        } else {
            date = Age._$1(this.param, ctx);
            if (date == null) {
                return null;
            }
        }
        if (now == null) {
            now = new Date();
        }
        boolean isYear = false;
        boolean isMonth = false;
        if (this.option != null) {
            if (this.option.indexOf(121) != -1) {
                isYear = true;
            }
            if (this.option.indexOf(109) != -1) {
                isMonth = true;
            }
        }
        int year1 = DateFactory.get().year(date);
        int year2 = DateFactory.get().year(now);
        if (isMonth) {
            int month1 = DateFactory.get().month(date);
            int month2 = DateFactory.get().month(now);
            if (month2 >= month1) {
                return ObjectCache.getInteger(year2 - year1);
            }
            return ObjectCache.getInteger(year2 - year1 - 1);
        }
        if (isYear) {
            return ObjectCache.getInteger(year2 - year1);
        }
        int month1 = DateFactory.get().month(date);
        int month2 = DateFactory.get().month(now);
        if (month2 > month1) {
            return ObjectCache.getInteger(year2 - year1);
        }
        if (month2 < month1) {
            return ObjectCache.getInteger(year2 - year1 - 1);
        }
        int day1 = DateFactory.get().day(date);
        int day2 = DateFactory.get().day(now);
        if (day2 >= day1) {
            return ObjectCache.getInteger(year2 - year1);
        }
        return ObjectCache.getInteger(year2 - year1 - 1);
    }

    private static Date _$1(IParam param, Context ctx) {
        if (param.isLeaf()) {
            Object date = param.getLeafExpression().calculate(ctx);
            if (date instanceof Date) {
                return (Date)date;
            }
            if (date instanceof String) {
                DateFormat format = DateFormatFactory.get().getDateFormat();
                format.getCalendar().setLenient(false);
                try {
                    return format.parse((String)date);
                }
                catch (ParseException e) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("age" + mm.getMessage("function.invalidParam"), e);
                }
            }
            if (date == null) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("age" + mm.getMessage("function.paramTypeError"));
        }
        if (param.getType() == ':') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("age" + mm.getMessage("function.invalidParam"));
            }
            IParam sub = param.getSub(0);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("age" + mm.getMessage("function.invalidParam"));
            }
            Object date = sub.getLeafExpression().calculate(ctx);
            if (date instanceof Date) {
                return (Date)date;
            }
            if (date instanceof String) {
                DateFormat format;
                sub = param.getSub(1);
                if (sub == null) {
                    format = DateFormatFactory.get().getDateFormat();
                } else {
                    Object strFormat = sub.getLeafExpression().calculate(ctx);
                    if (strFormat instanceof String) {
                        format = DateFormatFactory.get().getFormat((String)strFormat);
                    } else if (strFormat == null) {
                        format = DateFormatFactory.get().getDateFormat();
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("age" + mm.getMessage("function.paramTypeError"));
                    }
                }
                format.getCalendar().setLenient(false);
                try {
                    return format.parse((String)date);
                }
                catch (ParseException e) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("age" + mm.getMessage("function.invalidParam"), e);
                }
            }
            if (date == null) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("age" + mm.getMessage("function.paramTypeError"));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("age" + mm.getMessage("function.invalidParam"));
    }
}

