/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.NumberArray;
import com.scudata.array.StringArray;
import com.scudata.common.DateFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.Calendar;
import java.util.Date;

public class Day
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("day" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("day" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object val = this.param.getLeafExpression().calculate(ctx);
        if (val instanceof Number) {
            int days = ((Number)val).intValue();
            days = this.option == null || this.option.indexOf(119) == -1 ? DateFactory.toDay(days) : DateFactory.get().week(days);
            return ObjectCache.getInteger(days);
        }
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            val = Variant.parseDate((String)val);
        }
        if (val instanceof Date) {
            if (this.option == null || this.option.indexOf(119) == -1) {
                int day = DateFactory.get().day((Date)val);
                return ObjectCache.getInteger(day);
            }
            int week = DateFactory.get().week((Date)val);
            return ObjectCache.getInteger(week);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("day" + mm.getMessage("function.paramTypeError"));
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        boolean isMonth = this.option == null || this.option.indexOf(119) == -1;
        DateFactory df = DateFactory.get();
        Calendar calendar = df.calendar();
        if (array instanceof ConstArray) {
            Object obj = array.get(1);
            if (obj != null) {
                int day = Day._$1(obj, calendar, isMonth);
                Integer value = ObjectCache.getInteger(day);
                return new ConstArray(value, size);
            }
            return new ConstArray(null, size);
        }
        IntArray result = new IntArray(size);
        result.setTemporary(true);
        if (array instanceof DateArray) {
            DateArray dateArray = (DateArray)array;
            for (int i = 1; i <= size; ++i) {
                Date date = dateArray.getDate(i);
                if (date != null) {
                    result.pushInt(Day._$1(date, calendar, isMonth));
                    continue;
                }
                result.pushNull();
            }
        } else if (array instanceof NumberArray) {
            for (int i = 1; i <= size; ++i) {
                if (array.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                int days = array.getInt(i);
                days = isMonth ? DateFactory.toDay(days) : df.week(days);
                result.pushInt(days);
            }
        } else if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            for (int i = 1; i <= size; ++i) {
                String str = stringArray.getString(i);
                if (str != null) {
                    Object obj = Variant.parseDate(str);
                    if (obj instanceof Date) {
                        result.pushInt(Day._$1((Date)obj, calendar, isMonth));
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("day" + mm.getMessage("function.paramTypeError"));
                }
                result.pushNull();
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                Object obj = array.get(i);
                if (obj != null) {
                    int day = Day._$1(obj, calendar, isMonth);
                    result.pushInt(day);
                    continue;
                }
                result.pushNull();
            }
        }
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        boolean isMonth = this.option == null || this.option.indexOf(119) == -1;
        DateFactory df = DateFactory.get();
        Calendar calendar = df.calendar();
        boolean[] signDatas = sign ? signArray.isTrue().getDatas() : signArray.isFalse().getDatas();
        if (array instanceof ConstArray) {
            Object obj = array.get(1);
            if (obj != null) {
                int day = Day._$1(obj, calendar, isMonth);
                Integer value = ObjectCache.getInteger(day);
                return new ConstArray(value, size);
            }
            return new ConstArray(null, size);
        }
        IntArray result = new IntArray(size);
        result.setTemporary(true);
        if (array instanceof DateArray) {
            DateArray dateArray = (DateArray)array;
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Date date = dateArray.getDate(i);
                    if (date != null) {
                        result.pushInt(Day._$1(date, calendar, isMonth));
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        } else if (array instanceof NumberArray) {
            for (int i = 1; i <= size; ++i) {
                if (!signDatas[i]) {
                    result.pushInt(0);
                    continue;
                }
                if (array.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                int days = array.getInt(i);
                days = isMonth ? DateFactory.toDay(days) : df.week(days);
                result.pushInt(days);
            }
        } else if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            for (int i = 1; i <= size; ++i) {
                if (!signDatas[i]) {
                    result.pushInt(0);
                    continue;
                }
                if (stringArray.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                Object obj = Variant.parseDate(stringArray.getString(i));
                if (obj instanceof Date) {
                    result.pushInt(Day._$1((Date)obj, calendar, isMonth));
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("day" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                if (!signDatas[i]) {
                    result.pushInt(0);
                    continue;
                }
                if (array.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                int day = Day._$1(array.get(i), calendar, isMonth);
                result.pushInt(day);
            }
        }
        return result;
    }

    private static int _$1(Date date, Calendar calendar, boolean isMonth) {
        calendar.setTime(date);
        if (isMonth) {
            return calendar.get(5);
        }
        return calendar.get(7);
    }

    private static int _$1(Object obj, Calendar calendar, boolean isMonth) {
        if (obj instanceof Number) {
            int days = ((Number)obj).intValue();
            if (isMonth) {
                return DateFactory.toDay(days);
            }
            return DateFactory.get().week(days);
        }
        if (obj instanceof String) {
            obj = Variant.parseDate((String)obj);
        }
        if (obj instanceof Date) {
            calendar.setTime((Date)obj);
            if (isMonth) {
                return calendar.get(5);
            }
            return calendar.get(7);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("day" + mm.getMessage("function.paramTypeError"));
    }
}

