/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.NumberArray;
import com.scudata.array.StringArray;
import com.scudata.common.DateFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.Calendar;
import java.util.Date;

public class Days
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("days" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("days" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object value = this.param.getLeafExpression().calculate(ctx);
        if (value instanceof String) {
            value = Variant.parseDate((String)value);
        } else if (value == null) {
            return null;
        }
        if (this.option != null) {
            if (this.option.indexOf(121) != -1) {
                if (value instanceof Date) {
                    return ObjectCache.getInteger(DateFactory.get().daysInYear((Date)value));
                }
                if (value instanceof Number) {
                    return ObjectCache.getInteger(DateFactory.get().daysInYear(((Number)value).intValue()));
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("days" + mm.getMessage("function.paramTypeError"));
            }
            if (this.option.indexOf(113) != -1) {
                if (!(value instanceof Date)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("days" + mm.getMessage("function.paramTypeError"));
                }
                Date date = (Date)value;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(5, 1);
                int month = calendar.get(2);
                month = month < 3 ? 0 : (month < 6 ? 3 : (month < 9 ? 6 : 9));
                int count = 0;
                for (int i = 0; i < 3; ++i) {
                    calendar.set(2, month + i);
                    count += calendar.getActualMaximum(5);
                }
                return ObjectCache.getInteger(count);
            }
            if (this.option.indexOf(111) != -1) {
                if (!(value instanceof Date)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("days" + mm.getMessage("function.paramTypeError"));
                }
                return ObjectCache.getInteger(DateFactory.toDays((Date)value));
            }
        }
        if (value instanceof Date) {
            return ObjectCache.getInteger(DateFactory.get().daysInMonth((Date)value));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("days" + mm.getMessage("function.paramTypeError"));
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        Calendar calendar = DateFactory.get().calendar();
        char opt = 'm';
        if (this.option != null) {
            if (this.option.indexOf(121) != -1) {
                opt = 'y';
            } else if (this.option.indexOf(113) != -1) {
                opt = 'q';
            } else if (this.option.indexOf(111) != -1) {
                opt = 'o';
            }
        }
        if (array instanceof ConstArray) {
            Object obj = array.get(1);
            if (obj != null) {
                int days = Days._$1(obj, calendar, opt);
                return new ConstArray(ObjectCache.getInteger(days), size);
            }
            return new ConstArray(null, size);
        }
        IntArray result = new IntArray(size);
        result.setTemporary(true);
        if (array instanceof DateArray) {
            DateArray dateArray = (DateArray)array;
            for (int i = 1; i <= size; ++i) {
                Date date = dateArray.getDate(i);
                if (date != null) {
                    result.pushInt(Days._$1(date, calendar, opt));
                    continue;
                }
                result.pushNull();
            }
        } else if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            for (int i = 1; i <= size; ++i) {
                String str = stringArray.getString(i);
                if (str != null) {
                    Object obj = Variant.parseDate(str);
                    if (obj instanceof Date) {
                        result.pushInt(Days._$1((Date)obj, calendar, opt));
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("days" + mm.getMessage("function.paramTypeError"));
                }
                result.pushNull();
            }
        } else if (array instanceof NumberArray) {
            if (opt != 'y') {
                MessageManager mm = EngineMessage.get();
                throw new RQException("days" + mm.getMessage("function.paramTypeError"));
            }
            calendar.set(6, 1);
            for (int i = 1; i <= size; ++i) {
                if (array.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                calendar.set(1, array.getInt(i));
                result.pushInt(calendar.getActualMaximum(6));
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                Object obj = array.get(i);
                if (obj != null) {
                    int days = Days._$1(obj, calendar, opt);
                    result.pushInt(days);
                    continue;
                }
                result.pushNull();
            }
        }
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        Calendar calendar = DateFactory.get().calendar();
        char opt = 'm';
        if (this.option != null) {
            if (this.option.indexOf(121) != -1) {
                opt = 'y';
            } else if (this.option.indexOf(113) != -1) {
                opt = 'q';
            } else if (this.option.indexOf(111) != -1) {
                opt = 'o';
            }
        }
        if (array instanceof ConstArray) {
            Object obj = array.get(1);
            if (obj != null) {
                int days = Days._$1(obj, calendar, opt);
                return new ConstArray(ObjectCache.getInteger(days), size);
            }
            return new ConstArray(null, size);
        }
        boolean[] signDatas = sign ? signArray.isTrue().getDatas() : signArray.isFalse().getDatas();
        IntArray result = new IntArray(size);
        result.setTemporary(true);
        if (array instanceof DateArray) {
            DateArray dateArray = (DateArray)array;
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Date date = dateArray.getDate(i);
                    if (date != null) {
                        result.pushInt(Days._$1(date, calendar, opt));
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        } else if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    String str = stringArray.getString(i);
                    if (str != null) {
                        Object obj = Variant.parseDate(str);
                        if (obj instanceof Date) {
                            result.pushInt(Days._$1((Date)obj, calendar, opt));
                            continue;
                        }
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("days" + mm.getMessage("function.paramTypeError"));
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        } else if (array instanceof NumberArray) {
            if (opt != 'y') {
                MessageManager mm = EngineMessage.get();
                throw new RQException("days" + mm.getMessage("function.paramTypeError"));
            }
            calendar.set(6, 1);
            for (int i = 1; i <= size; ++i) {
                if (!signDatas[i]) {
                    result.pushInt(0);
                    continue;
                }
                if (array.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                calendar.set(1, array.getInt(i));
                result.pushInt(calendar.getActualMaximum(6));
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Object obj = array.get(i);
                    if (obj != null) {
                        int days = Days._$1(obj, calendar, opt);
                        result.pushInt(days);
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        }
        return result;
    }

    private static int _$1(Date date, Calendar calendar, char opt) {
        calendar.setTime(date);
        if (opt == 'm') {
            return calendar.getActualMaximum(5);
        }
        if (opt == 'q') {
            calendar.set(5, 1);
            int month = calendar.get(2);
            month = month < 3 ? 0 : (month < 6 ? 3 : (month < 9 ? 6 : 9));
            int count = 0;
            for (int i = 0; i < 3; ++i) {
                calendar.set(2, month + i);
                count += calendar.getActualMaximum(5);
            }
            return count;
        }
        if (opt == 'o') {
            return DateFactory.toDays(date);
        }
        return calendar.getActualMaximum(6);
    }

    private static int _$1(Object obj, Calendar calendar, char opt) {
        if (obj instanceof String) {
            obj = Variant.parseDate((String)obj);
        }
        if (obj instanceof Date) {
            calendar.setTime((Date)obj);
            if (opt == 'm') {
                return calendar.getActualMaximum(5);
            }
            if (opt == 'q') {
                calendar.set(5, 1);
                int month = calendar.get(2);
                month = month < 3 ? 0 : (month < 6 ? 3 : (month < 9 ? 6 : 9));
                int count = 0;
                for (int i = 0; i < 3; ++i) {
                    calendar.set(2, month + i);
                    count += calendar.getActualMaximum(5);
                }
                return count;
            }
            if (opt == 'o') {
                return DateFactory.toDays((Date)obj);
            }
            return calendar.getActualMaximum(6);
        }
        if (obj instanceof Number) {
            if (opt == 'y') {
                calendar.set(6, 1);
                calendar.set(1, ((Number)obj).intValue());
                return calendar.getActualMaximum(6);
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("days" + mm.getMessage("function.paramTypeError"));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("days" + mm.getMessage("function.paramTypeError"));
    }
}

