/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Constant;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.sql.Timestamp;
import java.util.Date;

public class Elapse
extends Function {
    public Node optimize(Context ctx) {
        boolean opt = this.param.optimize(ctx);
        if (opt && this.param.getSub(0) != null) {
            return new Constant(this.calculate(ctx));
        }
        return this;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("elapse" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("elapse" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        IParam sub2 = this.param.getSub(1);
        if (sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("elapse" + mm.getMessage("function.invalidParam"));
        }
        Object result2 = sub2.getLeafExpression().calculate(ctx);
        if (!(result2 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("elapse" + mm.getMessage("function.paramTypeError"));
        }
        IParam sub1 = this.param.getSub(0);
        if (sub1 != null) {
            Object result1 = sub1.getLeafExpression().calculate(ctx);
            return this._$1(result1, ((Number)result2).intValue());
        }
        return this._$1(null, ((Number)result2).intValue());
    }

    public IArray calculateAll(Context ctx) {
        NumberArray intArray;
        Object result;
        IParam sub2 = this.param.getSub(1);
        if (sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("elapse" + mm.getMessage("function.invalidParam"));
        }
        IArray array2 = sub2.getLeafExpression().calculateAll(ctx);
        int size = array2.size();
        IArray array1 = null;
        IParam sub1 = this.param.getSub(0);
        if (sub1 != null) {
            array1 = sub1.getLeafExpression().calculateAll(ctx);
        } else {
            Timestamp obj = new Timestamp(System.currentTimeMillis());
            array1 = new ConstArray(obj, size);
        }
        if (array1 instanceof ConstArray && array2 instanceof ConstArray) {
            result = this._$1(array1.get(1), array2.getInt(1));
            return new ConstArray(result, size);
        }
        if (array1 instanceof NumberArray && array2 instanceof ConstArray) {
            intArray = (NumberArray)array1;
            int interval = array2.getInt(1);
            IntArray result2 = new IntArray(size);
            result2.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                if (!intArray.isNull(i)) {
                    int date = Variant.elapse(intArray.getInt(i), interval, this.option);
                    result2.pushInt(date);
                    continue;
                }
                result2.pushNull();
            }
            return result2;
        }
        if (array1 instanceof NumberArray) {
            intArray = (NumberArray)array1;
            IntArray result3 = new IntArray(size);
            result3.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                if (!intArray.isNull(i)) {
                    int date = Variant.elapse(intArray.getInt(i), array2.getInt(i), this.option);
                    result3.pushInt(date);
                    continue;
                }
                result3.pushNull();
            }
            return result3;
        }
        result = new ObjectArray(size);
        ((ObjectArray)result).setTemporary(true);
        for (int i = 1; i <= size; ++i) {
            Object date = this._$1(array1.get(i), array2.getInt(i));
            ((ObjectArray)result).push(date);
        }
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        return this.calculateAll(ctx);
    }

    private Object _$1(Object obj, int interval) {
        if (obj == null) {
            obj = new Timestamp(System.currentTimeMillis());
        } else if (obj instanceof String) {
            if (!((obj = Variant.parseDate((String)obj)) instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            if (obj instanceof Integer) {
                int result = Variant.elapse((Integer)obj, interval, this.option);
                return ObjectCache.getInteger(result);
            }
            if (!(obj instanceof Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        }
        return Variant.elapse((Date)obj, interval, this.option);
    }
}

