/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.NumberArray;
import com.scudata.array.StringArray;
import com.scudata.common.DateFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.Calendar;
import java.util.Date;

public class Month
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("month" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("month" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object result = this.param.getLeafExpression().calculate(ctx);
        if (result instanceof Number) {
            int days = ((Number)result).intValue();
            days = this.option == null || this.option.indexOf(121) == -1 ? DateFactory.toMonth(days) : DateFactory.toYearMonth(days);
            return ObjectCache.getInteger(days);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            result = Variant.parseDate((String)result);
        }
        if (result instanceof Date) {
            if (this.option == null || this.option.indexOf(121) == -1) {
                int m = DateFactory.get().month((Date)result);
                return ObjectCache.getInteger(m);
            }
            DateFactory factory = DateFactory.get();
            Date date = (Date)result;
            int year = factory.year(date);
            int month = factory.month(date);
            return year * 100 + month;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("month" + mm.getMessage("function.paramTypeError"));
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        boolean monthOnly = this.option == null || this.option.indexOf(121) == -1;
        Calendar calendar = DateFactory.get().calendar();
        if (array instanceof ConstArray) {
            Object obj = array.get(1);
            if (obj != null) {
                int month = Month._$1(obj, calendar, monthOnly);
                Integer value = ObjectCache.getInteger(month);
                return new ConstArray(value, size);
            }
            return new ConstArray(null, size);
        }
        IntArray result = new IntArray(size);
        result.setTemporary(true);
        if (array instanceof DateArray) {
            DateArray dateArray = (DateArray)array;
            for (int i = 1; i <= size; ++i) {
                Date date = dateArray.getDate(i);
                if (date != null) {
                    result.pushInt(Month._$1(date, calendar, monthOnly));
                    continue;
                }
                result.pushNull();
            }
        } else if (array instanceof NumberArray) {
            for (int i = 1; i <= size; ++i) {
                if (array.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                int days = array.getInt(i);
                days = monthOnly ? DateFactory.toMonth(days) : DateFactory.toYearMonth(days);
                result.pushInt(days);
            }
        } else if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            for (int i = 1; i <= size; ++i) {
                String str = stringArray.getString(i);
                if (str != null) {
                    Object obj = Variant.parseDate(str);
                    if (obj instanceof Date) {
                        result.pushInt(Month._$1((Date)obj, calendar, monthOnly));
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("month" + mm.getMessage("function.paramTypeError"));
                }
                result.pushNull();
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                Object obj = array.get(i);
                if (obj != null) {
                    int month = Month._$1(obj, calendar, monthOnly);
                    result.pushInt(month);
                    continue;
                }
                result.pushNull();
            }
        }
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        boolean monthOnly = this.option == null || this.option.indexOf(121) == -1;
        Calendar calendar = DateFactory.get().calendar();
        if (array instanceof ConstArray) {
            Object obj = array.get(1);
            if (obj != null) {
                int month = Month._$1(obj, calendar, monthOnly);
                Integer value = ObjectCache.getInteger(month);
                return new ConstArray(value, size);
            }
            return new ConstArray(null, size);
        }
        boolean[] signDatas = sign ? signArray.isTrue().getDatas() : signArray.isFalse().getDatas();
        IntArray result = new IntArray(size);
        result.setTemporary(true);
        if (array instanceof DateArray) {
            DateArray dateArray = (DateArray)array;
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Date date = dateArray.getDate(i);
                    if (date != null) {
                        result.pushInt(Month._$1(date, calendar, monthOnly));
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        } else if (array instanceof NumberArray) {
            for (int i = 1; i <= size; ++i) {
                if (!signDatas[i]) {
                    result.pushInt(0);
                    continue;
                }
                if (array.isNull(i)) {
                    result.pushNull();
                    continue;
                }
                int days = array.getInt(i);
                days = monthOnly ? DateFactory.toMonth(days) : DateFactory.toYearMonth(days);
                result.pushInt(days);
            }
        } else if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    String str = stringArray.getString(i);
                    if (str != null) {
                        Object obj = Variant.parseDate(str);
                        if (obj instanceof Date) {
                            result.pushInt(Month._$1((Date)obj, calendar, monthOnly));
                            continue;
                        }
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("month" + mm.getMessage("function.paramTypeError"));
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Object obj = array.get(i);
                    if (obj != null) {
                        int month = Month._$1(obj, calendar, monthOnly);
                        result.pushInt(month);
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        }
        return result;
    }

    private static int _$1(Date date, Calendar calendar, boolean monthOnly) {
        calendar.setTime(date);
        if (monthOnly) {
            return calendar.get(2) + 1;
        }
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        return year * 100 + month;
    }

    private static int _$1(Object obj, Calendar calendar, boolean monthOnly) {
        if (obj instanceof Number) {
            int days = ((Number)obj).intValue();
            if (monthOnly) {
                return DateFactory.toMonth(days);
            }
            return DateFactory.toYearMonth(days);
        }
        if (obj instanceof String) {
            obj = Variant.parseDate((String)obj);
        }
        if (obj instanceof Date) {
            calendar.setTime((Date)obj);
            if (monthOnly) {
                return calendar.get(2) + 1;
            }
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            return year * 100 + month;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("month" + mm.getMessage("function.paramTypeError"));
    }

    public boolean isMonotone() {
        if (this.option == null || this.option.indexOf(121) == -1) {
            return false;
        }
        return this.param.getLeafExpression().isMonotone();
    }
}

