/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.Calendar;
import java.util.Date;

public class Period
extends Function {
    public Node optimize(Context ctx) {
        this.param.optimize(ctx);
        return this;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("period" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        IParam sub3;
        int size = this.param.getSubSize();
        if (size < 2 || size > 3) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("period" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("period" + mm.getMessage("function.invalidParam"));
        }
        Object start = sub1.getLeafExpression().calculate(ctx);
        Object end = sub2.getLeafExpression().calculate(ctx);
        if (start instanceof String) {
            start = Variant.parseDate((String)start);
        }
        if (end instanceof String) {
            end = Variant.parseDate((String)end);
        }
        if (!(start instanceof Date) || !(end instanceof Date)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("period" + mm.getMessage("function.paramTypeError"));
        }
        int dist = 1;
        if (size > 2 && (sub3 = this.param.getSub(2)) != null) {
            Object distance = sub3.getLeafExpression().calculate(ctx);
            if (!(distance instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("period" + mm.getMessage("function.paramTypeError"));
            }
            dist = ((Number)distance).intValue();
            if (dist == 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("period" + mm.getMessage("function.invalidParam"));
            }
        }
        if (this.option == null || this.option.indexOf(111) == -1 && this.option.indexOf(116) == -1) {
            return this._$1((Date)start, (Date)end, dist, this.option);
        }
        return this._$2((Date)start, (Date)end, dist, this.option);
    }

    private Sequence _$2(Date start, Date end, int distance, String opt) {
        Sequence series;
        block18: {
            Calendar gc;
            int field;
            block20: {
                block15: {
                    int endSign;
                    block19: {
                        int cmp;
                        block16: {
                            block17: {
                                int cmp2;
                                if (opt == null) {
                                    field = 5;
                                } else if (opt.indexOf(121) != -1) {
                                    field = 1;
                                } else if (opt.indexOf(113) != -1) {
                                    field = 2;
                                    distance *= 3;
                                } else {
                                    field = opt.indexOf(109) != -1 ? 2 : (opt.indexOf(116) != -1 ? -1 : (opt.indexOf(115) != -1 ? 13 : 5));
                                }
                                endSign = 0;
                                if (opt != null && opt.indexOf(120) != -1) {
                                    endSign = opt.indexOf(101) == -1 ? -1 : 1;
                                }
                                series = new Sequence();
                                series.add(start);
                                gc = Calendar.getInstance();
                                if (distance <= 0) break block15;
                                if (end.compareTo(start) < 0) {
                                    MessageManager mm = EngineMessage.get();
                                    throw new RQException("period" + mm.getMessage("function.invalidParam"));
                                }
                                if (field != -1) break block16;
                                Date prev = start;
                                gc.setTime(start);
                                int day = gc.get(5);
                                day = day < 11 ? 1 : (day < 21 ? 11 : 21);
                                while (true) {
                                    gc.setTime(prev);
                                    for (int i = 0; i < distance; ++i) {
                                        if ((day += 10) != 31) continue;
                                        day = 1;
                                        gc.set(5, 1);
                                        gc.add(2, 1);
                                    }
                                    gc.set(5, day);
                                    Date tmp = (Date)prev.clone();
                                    tmp.setTime(gc.getTimeInMillis());
                                    gc.clear();
                                    cmp2 = tmp.compareTo(end);
                                    if (cmp2 >= 0) break;
                                    series.add(tmp);
                                    prev = tmp;
                                }
                                if (cmp2 != 0) break block17;
                                if (endSign == -1) break block18;
                                series.add(end);
                                break block18;
                            }
                            if (endSign != 0) break block18;
                            series.add(end);
                            break block18;
                        }
                        int times = 1;
                        while (true) {
                            gc.setTime(start);
                            gc.add(field, distance * times);
                            Date tmp = (Date)start.clone();
                            tmp.setTime(gc.getTimeInMillis());
                            gc.clear();
                            cmp = tmp.compareTo(end);
                            if (cmp >= 0) break;
                            series.add(tmp);
                            ++times;
                        }
                        if (cmp != 0) break block19;
                        if (endSign == -1) break block18;
                        series.add(end);
                        break block18;
                    }
                    if (endSign != 0) break block18;
                    series.add(end);
                    break block18;
                }
                if (start.compareTo(end) < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("period" + mm.getMessage("function.invalidParam"));
                }
                if (field != -1) break block20;
                Date prev = start;
                gc.setTime(start);
                int day = gc.get(5);
                day = day < 11 ? 1 : (day < 21 ? 11 : 21);
                while (true) {
                    gc.setTime(prev);
                    for (int i = distance; i < 0; ++i) {
                        if ((day -= 10) >= 0) continue;
                        day = 21;
                        gc.set(5, 21);
                        gc.add(2, -1);
                    }
                    gc.set(5, day);
                    Date tmp = (Date)prev.clone();
                    tmp.setTime(gc.getTimeInMillis());
                    gc.clear();
                    int cmp = tmp.compareTo(end);
                    if (cmp <= 0) break;
                    series.add(tmp);
                    prev = tmp;
                }
                if (opt != null && opt.indexOf(120) != -1) break block18;
                series.add(end);
                break block18;
            }
            int times = 1;
            while (true) {
                gc.setTime(start);
                gc.add(field, distance * times);
                Date tmp = (Date)start.clone();
                tmp.setTime(gc.getTimeInMillis());
                gc.clear();
                int cmp = tmp.compareTo(end);
                if (cmp <= 0) break;
                series.add(tmp);
                ++times;
            }
            if (opt != null && opt.indexOf(120) != -1) break block18;
            series.add(end);
        }
        return series;
    }

    private Sequence _$1(Date start, Date end, int distance, String opt) {
        Sequence series;
        block17: {
            int times;
            long startTime;
            int field;
            Calendar gc;
            block15: {
                int endSign;
                block16: {
                    int cmp;
                    endSign = 0;
                    if (opt != null && opt.indexOf(120) != -1) {
                        endSign = opt.indexOf(101) == -1 ? -1 : 1;
                    }
                    gc = Calendar.getInstance();
                    gc.setTime(start);
                    if (opt == null) {
                        field = 5;
                        gc.set(11, 0);
                        gc.set(12, 0);
                        gc.set(13, 0);
                        gc.set(14, 0);
                    } else if (opt.indexOf(121) != -1) {
                        field = 1;
                        gc.set(5, 1);
                        gc.set(2, 0);
                        gc.set(11, 0);
                        gc.set(12, 0);
                        gc.set(13, 0);
                        gc.set(14, 0);
                    } else if (opt.indexOf(113) != -1) {
                        field = 2;
                        distance *= 3;
                        int month = gc.get(2);
                        month = month < 3 ? 0 : (month < 6 ? 3 : (month < 9 ? 6 : 9));
                        gc.set(5, 1);
                        gc.set(2, month);
                        gc.set(11, 0);
                        gc.set(12, 0);
                        gc.set(13, 0);
                        gc.set(14, 0);
                    } else if (opt.indexOf(109) != -1) {
                        field = 2;
                        gc.set(5, 1);
                        gc.set(11, 0);
                        gc.set(12, 0);
                        gc.set(13, 0);
                        gc.set(14, 0);
                    } else if (opt.indexOf(115) != -1) {
                        field = 13;
                        gc.set(14, 0);
                    } else {
                        field = 5;
                        gc.set(11, 0);
                        gc.set(12, 0);
                        gc.set(13, 0);
                        gc.set(14, 0);
                    }
                    startTime = gc.getTimeInMillis();
                    gc.clear();
                    series = new Sequence();
                    series.add(start);
                    times = 1;
                    if (distance <= 0) break block15;
                    if (end.compareTo(start) < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("period" + mm.getMessage("function.invalidParam"));
                    }
                    while (true) {
                        gc.setTimeInMillis(startTime);
                        gc.add(field, distance * times);
                        Date tmp = (Date)start.clone();
                        tmp.setTime(gc.getTimeInMillis());
                        gc.clear();
                        cmp = tmp.compareTo(end);
                        if (cmp >= 0) break;
                        series.add(tmp);
                        ++times;
                    }
                    if (cmp != 0) break block16;
                    if (endSign == -1) break block17;
                    series.add(end);
                    break block17;
                }
                if (endSign != 0) break block17;
                series.add(end);
                break block17;
            }
            if (start.compareTo(end) < 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("period" + mm.getMessage("function.invalidParam"));
            }
            while (true) {
                gc.setTimeInMillis(startTime);
                gc.add(field, distance * times);
                Date tmp = (Date)start.clone();
                tmp.setTime(gc.getTimeInMillis());
                gc.clear();
                int cmp = tmp.compareTo(end);
                if (cmp <= 0) break;
                series.add(tmp);
                ++times;
            }
            if (opt != null && opt.indexOf(120) != -1) break block17;
            series.add(end);
        }
        return series;
    }
}

