/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.array.ConstArray;
import com.scudata.array.DateArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.StringArray;
import com.scudata.common.DateFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.Calendar;
import java.util.Date;

public class Second
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("second" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("second" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object result = this.param.getLeafExpression().calculate(ctx);
        if (result instanceof String) {
            result = Variant.parseDate((String)result);
        }
        if (result instanceof Date) {
            return DateFactory.get().second((Date)result);
        }
        if (result == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("second" + mm.getMessage("function.paramTypeError"));
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        Calendar calendar = DateFactory.get().calendar();
        if (array instanceof ConstArray) {
            int second = Second._$1(array.get(1), calendar);
            Integer value = second != -1 ? ObjectCache.getInteger(second) : null;
            return new ConstArray(value, size);
        }
        IntArray result = new IntArray(size);
        result.setTemporary(true);
        if (array instanceof DateArray) {
            DateArray dateArray = (DateArray)array;
            for (int i = 1; i <= size; ++i) {
                Date date = dateArray.getDate(i);
                if (date != null) {
                    calendar.setTime(date);
                    result.pushInt(calendar.get(13));
                    continue;
                }
                result.pushNull();
            }
        } else if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            for (int i = 1; i <= size; ++i) {
                String str = stringArray.getString(i);
                if (str != null) {
                    Object obj = Variant.parseDate(str);
                    if (obj instanceof Date) {
                        calendar.setTime((Date)obj);
                        result.pushInt(calendar.get(13));
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("second" + mm.getMessage("function.paramTypeError"));
                }
                result.pushNull();
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                int second = Second._$1(array.get(i), calendar);
                if (second != -1) {
                    result.pushInt(second);
                    continue;
                }
                result.pushNull();
            }
        }
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        Calendar calendar = DateFactory.get().calendar();
        if (array instanceof ConstArray) {
            int second = Second._$1(array.get(1), calendar);
            Integer value = second != -1 ? ObjectCache.getInteger(second) : null;
            return new ConstArray(value, size);
        }
        boolean[] signDatas = sign ? signArray.isTrue().getDatas() : signArray.isFalse().getDatas();
        IntArray result = new IntArray(size);
        result.setTemporary(true);
        if (array instanceof DateArray) {
            DateArray dateArray = (DateArray)array;
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Date date = dateArray.getDate(i);
                    if (date != null) {
                        calendar.setTime(date);
                        result.pushInt(calendar.get(13));
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        } else if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    String str = stringArray.getString(i);
                    if (str != null) {
                        Object obj = Variant.parseDate(str);
                        if (obj instanceof Date) {
                            calendar.setTime((Date)obj);
                            result.pushInt(calendar.get(13));
                            continue;
                        }
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("second" + mm.getMessage("function.paramTypeError"));
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    int second = Second._$1(array.get(i), calendar);
                    if (second != -1) {
                        result.pushInt(second);
                        continue;
                    }
                    result.pushNull();
                    continue;
                }
                result.pushInt(0);
            }
        }
        return result;
    }

    private static int _$1(Object obj, Calendar calendar) {
        if (obj instanceof String) {
            obj = Variant.parseDate((String)obj);
        }
        if (obj instanceof Date) {
            calendar.setTime((Date)obj);
            return calendar.get(13);
        }
        if (obj == null) {
            return -1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("second" + mm.getMessage("function.paramTypeError"));
    }
}

