/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.datetime;

import com.scudata.common.DateFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.fn.datetime.lIIIIllIllIIIlIl;
import com.scudata.resources.EngineMessage;
import java.util.Calendar;
import java.util.Date;

public class WorkDays
extends Function {
    public Node optimize(Context ctx) {
        this.param.optimize(ctx);
        return this;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("workdays" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        IParam sub3;
        int size = this.param.getSubSize();
        if (size != 2 && size != 3) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("workdays" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("workdays" + mm.getMessage("function.invalidParam"));
        }
        Object result1 = sub1.getLeafExpression().calculate(ctx);
        Object result2 = sub2.getLeafExpression().calculate(ctx);
        if (!(result1 instanceof Date) || !(result2 instanceof Date)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("workdays" + mm.getMessage("function.paramTypeError"));
        }
        Sequence offDays = null;
        if (size == 3 && (sub3 = this.param.getSub(2)) != null) {
            Object obj = sub3.getLeafExpression().calculate(ctx);
            if (obj instanceof Sequence) {
                offDays = (Sequence)obj;
            } else if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("workdays" + mm.getMessage("function.paramTypeError"));
            }
        }
        Date date1 = (Date)result1;
        Date date2 = (Date)result2;
        if (!(date1 instanceof java.sql.Date)) {
            date1 = DateFactory.get().toDate(date1);
        }
        if (!(date2 instanceof java.sql.Date)) {
            date2 = DateFactory.get().toDate(date2);
        }
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time1);
        boolean returnCount = false;
        if (this.option != null) {
            if (this.option.indexOf(110) != -1) {
                returnCount = true;
            }
            if (this.option.indexOf(120) != -1) {
                time2 = time1 <= time2 ? (time2 -= 86400000L) : (time2 += 86400000L);
            }
        }
        lIIIIllIllIIIlIl od = new lIIIIllIllIIIlIl(offDays, this.option);
        if (returnCount) {
            int count = 0;
            if (time1 <= time2) {
                while (time1 <= time2) {
                    if (od.isWorkDay(calendar)) {
                        ++count;
                    }
                    calendar.add(5, 1);
                    time1 = calendar.getTimeInMillis();
                }
            } else {
                while (time1 >= time2) {
                    if (od.isWorkDay(calendar)) {
                        ++count;
                    }
                    calendar.add(5, -1);
                    time1 = calendar.getTimeInMillis();
                }
            }
            return ObjectCache.getInteger(count);
        }
        Sequence seq = new Sequence();
        if (time1 <= time2) {
            while (time1 <= time2) {
                if (od.isWorkDay(calendar)) {
                    seq.add(new java.sql.Date(calendar.getTimeInMillis()));
                }
                calendar.add(5, 1);
                time1 = calendar.getTimeInMillis();
            }
        } else {
            while (time1 >= time2) {
                if (od.isWorkDay(calendar)) {
                    seq.add(new java.sql.Date(calendar.getTimeInMillis()));
                }
                calendar.add(5, -1);
                time1 = calendar.getTimeInMillis();
            }
        }
        return seq;
    }
}

