/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.gather;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.AvgValue;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Gather;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Average
extends Gather {
    private Expression _$2;
    private String _$1;

    public void setCountFieldName(String countFieldName) {
        this._$1 = countFieldName;
    }

    public void prepare(Context ctx) {
        if (this.param == null || !this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("avg" + mm.getMessage("function.invalidParam"));
        }
        this._$2 = this.param.getLeafExpression();
    }

    public Object gather(Context ctx) {
        Object val = this._$2.calculate(ctx);
        if (val instanceof AvgValue) {
            return val;
        }
        return new AvgValue(val);
    }

    public Object gather(Object oldValue, Context ctx) {
        Object val = this._$2.calculate(ctx);
        if (oldValue == null) {
            if (val instanceof AvgValue) {
                return val;
            }
            return new AvgValue(val);
        }
        ((AvgValue)oldValue).add(val);
        return oldValue;
    }

    public Expression getRegatherExpression(int q) {
        if (this._$1 == null) {
            String str = "avg(#" + q + ")";
            return new Expression(str);
        }
        String str = "sum(#" + q + ")";
        return new Expression(str);
    }

    public boolean needFinish() {
        return this._$1 == null;
    }

    public Object finish(Object val) {
        if (val instanceof AvgValue) {
            return ((AvgValue)val).getAvgValue();
        }
        return val;
    }

    public Object calculate(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("avg" + mm.getMessage("function.missingParam"));
        }
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Sequence) {
                return ((Sequence)obj).average();
            }
            if (obj instanceof Number) {
                return obj;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("avg" + mm.getMessage("function.paramTypeError"));
        }
        Object result = null;
        int count = 0;
        int size = this.param.getSubSize();
        for (int i = 0; i < size; ++i) {
            Object obj;
            IParam sub = this.param.getSub(i);
            if (sub == null || (obj = sub.getLeafExpression().calculate(ctx)) == null) continue;
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("avg" + mm.getMessage("function.paramTypeError"));
            }
            ++count;
            result = Variant.add(result, obj);
        }
        return Variant.avg(result, count);
    }

    public Expression getExp() {
        return this._$2;
    }

    public IArray gather(IArray sumResult, LongArray countResult, int[] resultSeqs, Context ctx) {
        IArray array = this._$2.calculateAll(ctx);
        if (sumResult == null) {
            if (array instanceof IntArray) {
                sumResult = new LongArray(8191);
            } else {
                sumResult = array.newInstance(8191);
                if (sumResult instanceof IntArray) {
                    sumResult = new LongArray(8191);
                }
            }
        }
        int len = array.size();
        for (int i = 1; i <= len; ++i) {
            if (sumResult.size() < resultSeqs[i]) {
                sumResult.add(array, i);
                if (array.isNull(i)) {
                    countResult.addLong(0L);
                    continue;
                }
                countResult.addLong(1L);
                continue;
            }
            if (array.isNull(i)) continue;
            sumResult = sumResult.memberAdd(resultSeqs[i], array, i);
            countResult.plus1(resultSeqs[i]);
        }
        return sumResult;
    }
}

