/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.gather;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.Gather;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Min
extends Gather {
    private Expression _$1;

    public void prepare(Context ctx) {
        if (this.param == null || !this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("min" + mm.getMessage("function.invalidParam"));
        }
        this._$1 = this.param.getLeafExpression();
    }

    public Object gather(Context ctx) {
        return this._$1.calculate(ctx);
    }

    public Object gather(Object oldValue, Context ctx) {
        Object val = this._$1.calculate(ctx);
        if (val != null && (oldValue == null || Variant.compare(val, oldValue, true) < 0)) {
            return val;
        }
        return oldValue;
    }

    public Expression getRegatherExpression(int q) {
        String str = "min(#" + q + ")";
        return new Expression(str);
    }

    public Object calculate(Context ctx) {
        IParam param = this.param;
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("min" + mm.getMessage("function.missingParam"));
        }
        if (param.isLeaf()) {
            Object obj = param.getLeafExpression().calculate(ctx);
            if (obj instanceof Sequence) {
                return ((Sequence)obj).min();
            }
            return obj;
        }
        IParam sub = param.getSub(0);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("min" + mm.getMessage("function.invalidParam"));
        }
        Object minVal = sub.getLeafExpression().calculate(ctx);
        int size = param.getSubSize();
        for (int i = 1; i < size; ++i) {
            sub = param.getSub(i);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("min" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub.getLeafExpression().calculate(ctx);
            if (obj == null || minVal != null && Variant.compare(minVal, obj, true) <= 0) continue;
            minVal = obj;
        }
        return minVal;
    }

    public IArray gather(IArray result, int[] resultSeqs, Context ctx) {
        IArray array = this._$1.calculateAll(ctx);
        if (result == null) {
            result = array.newInstance(8191);
        }
        int len = array.size();
        for (int i = 1; i <= len; ++i) {
            if (result.size() < resultSeqs[i]) {
                result.add(array, i);
                continue;
            }
            if (array.isNull(i) || result.compareTo(resultSeqs[i], array, i) <= 0) continue;
            result.set(resultSeqs[i], array, i);
        }
        return result;
    }

    public void gather2(IArray result, IArray result2, int[] seqs, Context ctx) {
        int len = result2.size();
        for (int i = 1; i <= len; ++i) {
            if (seqs[i] == 0 || result.compareTo(seqs[i], result2, i) <= 0) continue;
            result.set(seqs[i], result2, i);
        }
    }
}

