/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.gather;

import com.scudata.array.ObjectArray;
import java.util.Comparator;

class RankArray {
    private ObjectArray valueArray;
    private final int count;
    private int curCount = 0;
    private boolean isDistinct;

    public RankArray(int count, boolean isDistinct) {
        this.valueArray = new ObjectArray(count * 2);
        this.count = count;
        this.isDistinct = isDistinct;
    }

    public ObjectArray getValueArray() {
        return this.valueArray;
    }

    public void add(Object obj, Comparator<Object> comparator) {
        ObjectArray valueArray = this.valueArray;
        if (this.isDistinct) {
            if (this.curCount < this.count) {
                int index = valueArray.binarySearch(obj, comparator);
                if (index < 1) {
                    ++this.curCount;
                    index = -index;
                }
                valueArray.insert(index, obj);
            } else {
                int curSize = valueArray.size();
                int cmp = comparator.compare(obj, valueArray.get(curSize));
                if (cmp < 0) {
                    int index = valueArray.binarySearch(obj, comparator);
                    if (index < 1) {
                        index = -index;
                        Object value = valueArray.get(curSize);
                        valueArray.removeLast();
                        int j = curSize - 1;
                        while (j >= this.count) {
                            if (comparator.compare(valueArray.get(j), value) != 0) break;
                            valueArray.removeLast();
                            --j;
                        }
                    }
                    valueArray.insert(index, obj);
                } else if (cmp == 0) {
                    valueArray.add(obj);
                }
            }
        } else {
            int curSize = valueArray.size();
            if (curSize < this.count) {
                int index = valueArray.binarySearch(obj, comparator);
                if (index < 1) {
                    index = -index;
                }
                valueArray.insert(index, obj);
            } else {
                int cmp = comparator.compare(obj, valueArray.get(curSize));
                if (cmp < 0) {
                    int index = valueArray.binarySearch(obj, comparator);
                    if (index < 1) {
                        index = -index;
                    }
                    Object value = valueArray.get(curSize);
                    valueArray.insert(index, obj);
                    if (comparator.compare(valueArray.get(this.count), value) != 0) {
                        valueArray.removeLast();
                        int j = curSize;
                        while (j > this.count) {
                            if (comparator.compare(valueArray.get(j), value) == 0) {
                                valueArray.removeLast();
                                --j;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (cmp == 0) {
                    valueArray.add(obj);
                }
            }
        }
    }
}

