/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class Arctanh
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("atanh" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("atanh" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object obj = this.param.getLeafExpression().calculate(ctx);
        if (obj instanceof Number) {
            double z = ((Number)obj).doubleValue();
            return new Double(0.5 * Math.log((1.0 + z) / (1.0 - z)));
        }
        if (obj == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("atanh" + mm.getMessage("function.paramTypeError"));
    }
}

