/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Bits
extends Function {
    private static final char[] _$1 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static int _$1(String s, int radix) {
        if (s.length() != 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("bits" + mm.getMessage("function.invalidParam"));
        }
        char c = s.charAt(0);
        int n = c < 'A' ? c - 48 : (c < 'a' ? c - 65 + 10 : c - 97 + 10);
        if (n < 0 || n >= radix) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("bits" + mm.getMessage("function.invalidParam"));
        }
        return n;
    }

    private static String _$1(String str) {
        char[] chars = str.toCharArray();
        int i = 0;
        for (int j = chars.length - 1; i < j; ++i, --j) {
            char c = chars[i];
            chars[i] = chars[j];
            chars[j] = c;
        }
        return new String(chars);
    }

    private static String _$1(Number num, int radix, boolean bigEnding) {
        if (num instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)num;
            if (decimal.scale() != 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
            }
            String str = decimal.unscaledValue().toString(radix);
            if (bigEnding) {
                return Bits._$1(str);
            }
            return str;
        }
        if (num instanceof BigInteger) {
            String str = ((BigInteger)num).toString(radix);
            if (bigEnding) {
                return Bits._$1(str);
            }
            return str;
        }
        return Bits._$1(num.longValue(), radix, bigEnding);
    }

    private static String _$1(long v, int radix, boolean bigEnding) {
        if (bigEnding) {
            String str;
            switch (radix) {
                case 10: {
                    str = Long.toString(v);
                    break;
                }
                case 16: {
                    str = Long.toHexString(v);
                    break;
                }
                default: {
                    str = Long.toBinaryString(v);
                }
            }
            return Bits._$1(str);
        }
        switch (radix) {
            case 10: {
                return Long.toString(v);
            }
            case 16: {
                return Long.toHexString(v);
            }
        }
        return Long.toBinaryString(v);
    }

    private static String _$1(IParam param, Context ctx, int radix, boolean reverse) {
        int size = param.getSubSize();
        char[] chars = new char[size];
        if (reverse) {
            int i = 0;
            int j = size - 1;
            while (i < size) {
                IParam sub = param.getSub(i);
                if (sub == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                }
                Object obj = sub.getLeafExpression().calculate(ctx);
                if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n < 0 || n >= radix) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                    }
                    chars[j] = _$1[n];
                } else if (obj instanceof String) {
                    chars[j] = _$1[Bits._$1((String)obj, radix)];
                } else if (radix == 2 && obj instanceof Boolean) {
                    chars[j] = ((Boolean)obj).booleanValue() ? 49 : 48;
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
                }
                ++i;
                --j;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                IParam sub = param.getSub(i);
                if (sub == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                }
                Object obj = sub.getLeafExpression().calculate(ctx);
                if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n < 0 || n >= radix) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                    }
                    chars[i] = _$1[n];
                    continue;
                }
                if (obj instanceof String) {
                    chars[i] = _$1[Bits._$1((String)obj, radix)];
                    continue;
                }
                if (radix == 2 && obj instanceof Boolean) {
                    if (((Boolean)obj).booleanValue()) {
                        chars[i] = 49;
                        continue;
                    }
                    chars[i] = 48;
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
            }
        }
        return new String(chars);
    }

    private static String _$1(Sequence seq, int radix, boolean reverse) {
        int size = seq.length();
        char[] chars = new char[size];
        if (reverse) {
            int i = 1;
            int j = size - 1;
            while (i <= size) {
                Object obj = seq.getMem(i);
                if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n < 0 || n >= radix) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                    }
                    chars[j] = _$1[n];
                } else if (obj instanceof String) {
                    chars[j] = _$1[Bits._$1((String)obj, radix)];
                } else if (radix == 2 && obj instanceof Boolean) {
                    chars[j] = ((Boolean)obj).booleanValue() ? 49 : 48;
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
                }
                ++i;
                --j;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Object obj = seq.getMem(i + 1);
                if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n < 0 || n >= radix) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                    }
                    chars[i] = _$1[n];
                    continue;
                }
                if (obj instanceof String) {
                    chars[i] = _$1[Bits._$1((String)obj, radix)];
                    continue;
                }
                if (radix == 2 && obj instanceof Boolean) {
                    if (((Boolean)obj).booleanValue()) {
                        chars[i] = 49;
                        continue;
                    }
                    chars[i] = 48;
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
            }
        }
        return new String(chars);
    }

    private static long _$1(IParam param, Context ctx, int radix, boolean isBool, boolean bigEnding) {
        int size = param.getSubSize();
        long result = 0L;
        if (bigEnding) {
            for (int i = size - 1; i >= 0; --i) {
                IParam sub = param.getSub(i);
                if (sub == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                }
                Object obj = sub.getLeafExpression().calculate(ctx);
                if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n < 0 || n >= radix) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                    }
                    result = result * (long)radix + (long)n;
                    continue;
                }
                if (obj instanceof String) {
                    result = result * (long)radix + (long)Bits._$1((String)obj, radix);
                    continue;
                }
                if (isBool && obj instanceof Boolean) {
                    if (((Boolean)obj).booleanValue()) {
                        result = result * 2L + 1L;
                        continue;
                    }
                    result *= 2L;
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                IParam sub = param.getSub(i);
                if (sub == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                }
                Object obj = sub.getLeafExpression().calculate(ctx);
                if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n < 0 || n >= radix) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                    }
                    result = result * (long)radix + (long)n;
                    continue;
                }
                if (obj instanceof String) {
                    result = result * (long)radix + (long)Bits._$1((String)obj, radix);
                    continue;
                }
                if (isBool && obj instanceof Boolean) {
                    if (((Boolean)obj).booleanValue()) {
                        result = result * 2L + 1L;
                        continue;
                    }
                    result *= 2L;
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
            }
        }
        return result;
    }

    private static long _$1(Sequence seq, int radix, boolean isBool, boolean bigEnding) {
        int size = seq.length();
        long result = 0L;
        if (bigEnding) {
            for (int i = size; i > 0; --i) {
                Object obj = seq.getMem(i);
                if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n < 0 || n >= radix) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                    }
                    result = result * (long)radix + (long)n;
                    continue;
                }
                if (obj instanceof String) {
                    result = result * (long)radix + (long)Bits._$1((String)obj, radix);
                    continue;
                }
                if (isBool && obj instanceof Boolean) {
                    if (((Boolean)obj).booleanValue()) {
                        result = result * 2L + 1L;
                        continue;
                    }
                    result *= 2L;
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            for (int i = 1; i <= size; ++i) {
                Object obj = seq.getMem(i);
                if (obj instanceof Number) {
                    int n = ((Number)obj).intValue();
                    if (n < 0 || n >= radix) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("bits" + mm.getMessage("function.invalidParam"));
                    }
                    result = result * (long)radix + (long)n;
                    continue;
                }
                if (obj instanceof String) {
                    result = result * (long)radix + (long)Bits._$1((String)obj, radix);
                    continue;
                }
                if (isBool && obj instanceof Boolean) {
                    if (((Boolean)obj).booleanValue()) {
                        result = result * 2L + 1L;
                        continue;
                    }
                    result *= 2L;
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
            }
        }
        return result;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("bits" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        int radix = 2;
        boolean isBool = false;
        boolean returnString = false;
        boolean returnDecimal = false;
        boolean bigEnding = false;
        if (this.option != null) {
            if (this.option.indexOf(49) != -1) {
                return ObjectCache.getInteger(Bits._$1(this.param, ctx));
            }
            if (this.option.indexOf(104) != -1) {
                radix = 16;
            } else if (this.option.indexOf(100) != -1) {
                radix = 10;
            } else if (this.option.indexOf(98) != -1) {
                isBool = true;
            }
            if (this.option.indexOf(115) != -1) {
                returnString = true;
            } else if (this.option.indexOf(110) != -1) {
                returnDecimal = true;
            }
            if (this.option.indexOf(114) != -1) {
                bigEnding = true;
            }
        }
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (obj instanceof String) {
                String str = (String)obj;
                if (bigEnding) {
                    str = Bits._$1(str);
                }
                if (returnDecimal) {
                    BigInteger bi = new BigInteger(str, radix);
                    return new BigDecimal(bi);
                }
                return Long.parseLong(str, radix);
            }
            if (obj instanceof Number) {
                if (returnString) {
                    return Bits._$1((Number)obj, radix, bigEnding);
                }
                if (returnDecimal) {
                    if (obj instanceof BigDecimal) {
                        return obj;
                    }
                    if (obj instanceof BigInteger) {
                        return new BigDecimal((BigInteger)obj);
                    }
                    return new BigDecimal(((Number)obj).longValue());
                }
                return obj;
            }
            if (obj instanceof Sequence) {
                if (returnString) {
                    return Bits._$1((Sequence)obj, radix, false);
                }
                if (returnDecimal) {
                    String str = Bits._$1((Sequence)obj, radix, bigEnding);
                    BigInteger bi = new BigInteger(str, radix);
                    return bi;
                }
                return Bits._$1((Sequence)obj, radix, isBool, bigEnding);
            }
            if (isBool) {
                boolean b = Variant.isTrue(obj);
                if (returnString) {
                    return b ? "1" : "0";
                }
                if (returnDecimal) {
                    return new BigDecimal(b ? 1 : 0);
                }
                return b ? 1L : 0L;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
        }
        if (returnString) {
            return Bits._$1(this.param, ctx, radix, false);
        }
        if (returnDecimal) {
            String str = Bits._$1(this.param, ctx, radix, bigEnding);
            BigInteger bi = new BigInteger(str, radix);
            return bi;
        }
        return Bits._$1(this.param, ctx, radix, isBool, bigEnding);
    }

    private static int _$1(Object obj) {
        if (obj instanceof Long) {
            return Long.bitCount((Long)obj);
        }
        if (obj instanceof BigInteger) {
            return ((BigInteger)obj).bitCount();
        }
        if (obj instanceof Number) {
            return Integer.bitCount(((Number)obj).intValue());
        }
        if (obj == null) {
            return 0;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("bits" + mm.getMessage("function.paramTypeError"));
    }

    private static int _$1(IParam param, Context ctx) {
        if (param.isLeaf()) {
            Object obj = param.getLeafExpression().calculate(ctx);
            return Bits._$1(obj);
        }
        int size = param.getSubSize();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            IParam sub = param.getSub(i);
            if (sub == null || !sub.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("bits" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub.getLeafExpression().calculate(ctx);
            count += Bits._$1(obj);
        }
        return count;
    }

    public IArray calculateAll(Context ctx) {
        if (!this.param.isLeaf() || this.option == null || this.option.indexOf(49) == -1) {
            return super.calculateAll(ctx);
        }
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int len = array.size();
        IntArray result = new IntArray(len);
        if (array instanceof IntArray) {
            IntArray intArray = (IntArray)array;
            for (int i = 1; i <= len; ++i) {
                if (intArray.isNull(i)) {
                    result.pushInt(0);
                    continue;
                }
                result.pushInt(Integer.bitCount(intArray.getInt(i)));
            }
        } else if (array instanceof LongArray) {
            LongArray longArray = (LongArray)array;
            for (int i = 1; i <= len; ++i) {
                if (longArray.isNull(i)) {
                    result.pushInt(0);
                    continue;
                }
                result.pushInt(Long.bitCount(longArray.getLong(i)));
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                result.pushInt(Bits._$1(array.get(i)));
            }
        }
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        if (!this.param.isLeaf() || this.option == null || this.option.indexOf(49) == -1) {
            return super.calculateAll(ctx, signArray, sign);
        }
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int len = array.size();
        IntArray result = new IntArray(len);
        if (array instanceof IntArray) {
            IntArray intArray = (IntArray)array;
            for (int i = 1; i <= len; ++i) {
                if (intArray.isNull(i)) {
                    result.pushInt(0);
                    continue;
                }
                if (signArray.isTrue(i) == sign) {
                    result.pushInt(Integer.bitCount(intArray.getInt(i)));
                    continue;
                }
                result.pushInt(0);
            }
        } else if (array instanceof LongArray) {
            LongArray longArray = (LongArray)array;
            for (int i = 1; i <= len; ++i) {
                if (longArray.isNull(i)) {
                    result.pushInt(0);
                    continue;
                }
                if (signArray.isTrue(i) == sign) {
                    result.pushInt(Long.bitCount(longArray.getLong(i)));
                    continue;
                }
                result.pushInt(0);
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                if (signArray.isTrue(i) == sign) {
                    result.pushInt(Bits._$1(array.get(i)));
                    continue;
                }
                result.pushInt(0);
            }
        }
        return result;
    }
}

