/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Floor
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("floor" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object result1 = this.param.getLeafExpression().calculate(ctx);
            if (result1 == null) {
                return null;
            }
            if (result1 instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)result1;
                if (this.option == null || this.option.indexOf(115) == -1) {
                    return decimal.setScale(0, RoundingMode.FLOOR);
                }
                return decimal.setScale(0, RoundingMode.DOWN);
            }
            if (result1 instanceof Number) {
                if (this.option == null || this.option.indexOf(115) == -1) {
                    return new Double(Math.floor(Variant.doubleValue(result1)));
                }
                double d = Variant.doubleValue(result1);
                if (d < 0.0) {
                    return new Double(Math.ceil(d));
                }
                return new Double(Math.floor(d));
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("floor" + mm.getMessage("function.paramTypeError"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("floor" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("floor" + mm.getMessage("function.invalidParam"));
        }
        Object result1 = sub1.getLeafExpression().calculate(ctx);
        if (result1 == null) {
            return null;
        }
        if (!(result1 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("floor" + mm.getMessage("function.paramTypeError"));
        }
        Object result2 = sub2.getLeafExpression().calculate(ctx);
        if (result2 == null) {
            return null;
        }
        if (!(result2 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("floor" + mm.getMessage("function.paramTypeError"));
        }
        if (result1 instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)result1;
            int scale = ((Number)result2).intValue();
            decimal = this.option == null || this.option.indexOf(115) == -1 ? decimal.setScale(scale, RoundingMode.FLOOR) : decimal.setScale(scale, RoundingMode.DOWN);
            if (scale < 0) {
                return decimal.setScale(0);
            }
            return decimal;
        }
        double v = Variant.doubleValue(result1);
        double d = Math.pow(10.0, ((Number)result2).intValue());
        if (this.option == null || this.option.indexOf(115) == -1) {
            return new Double(Math.floor(v * d) / d);
        }
        if (v < 0.0) {
            return new Double(Math.ceil(v * d) / d);
        }
        return new Double(Math.floor(v * d) / d);
    }
}

