/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.ArrayList;
import java.util.Arrays;

public class Gcd
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("gcd" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        ArrayList<Number> num = new ArrayList<Number>();
        if (this.param.isLeaf()) {
            Object result = this.param.getLeafExpression().calculate(ctx);
            if (result != null && result instanceof Number) {
                num.add((Number)result);
            } else if (result != null && result instanceof Sequence) {
                int n = ((Sequence)result).length();
                for (int i = 1; i <= n; ++i) {
                    Object tmp = ((Sequence)result).get(i);
                    if (tmp == null || !(tmp instanceof Number)) continue;
                    num.add((Number)tmp);
                }
            }
        } else {
            int size = this.param.getSubSize();
            for (int j = 0; j < size; ++j) {
                IParam subj = this.param.getSub(j);
                if (subj == null) continue;
                Object result = subj.getLeafExpression().calculate(ctx);
                if (result != null && result instanceof Number) {
                    num.add((Number)result);
                    continue;
                }
                if (result == null || !(result instanceof Sequence)) continue;
                int n = ((Sequence)result).length();
                for (int i = 1; i <= n; ++i) {
                    Object tmp = ((Sequence)result).get(i);
                    if (tmp == null || !(tmp instanceof Number)) continue;
                    num.add((Number)tmp);
                }
            }
        }
        int k = num.size();
        Number[] nums = new Number[k];
        num.toArray(nums);
        return new Long(Gcd.gcd(nums, k));
    }

    public static long gcd(Number[] num, int k) {
        Arrays.sort(num);
        long d = Variant.longValue(num[0]);
        if (d < 0L) {
            return 0L;
        }
        for (int i = 1; i < k; ++i) {
            long d1 = Variant.longValue(num[i]);
            if (d1 < 0L) {
                return 0L;
            }
            d = Gcd._$1(d1, d);
        }
        return d;
    }

    private static long _$1(long max, long min) {
        if (max == min) {
            return max;
        }
        if (min > max) {
            long tmp = min;
            min = max;
            max = tmp;
        }
        if (min == 0L) {
            return max;
        }
        return Gcd._$1(min, max % min);
    }
}

