/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.array.ConstArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.NumberArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Pow
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("power" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object val = this.param.getLeafExpression().calculate(ctx);
            return Variant.square(val);
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("power" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("power" + mm.getMessage("function.invalidParam"));
        }
        Object result1 = sub1.getLeafExpression().calculate(ctx);
        if (result1 == null) {
            return null;
        }
        if (!(result1 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("power" + mm.getMessage("function.paramTypeError"));
        }
        Object result2 = sub2.getLeafExpression().calculate(ctx);
        if (result2 == null) {
            return null;
        }
        if (!(result2 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("power" + mm.getMessage("function.paramTypeError"));
        }
        return new Double(Math.pow(Variant.doubleValue(result1), Variant.doubleValue(result2)));
    }

    public IArray calculateAll(Context ctx) {
        if (this.param.isLeaf()) {
            IArray array = this.param.getLeafExpression().calculateAll(ctx);
            int size = array.size();
            if (array instanceof ConstArray) {
                Object obj = array.get(1);
                obj = Variant.square(obj);
                return new ConstArray(obj, size);
            }
            if (array instanceof IntArray) {
                IntArray numberArray = (IntArray)array;
                IntArray result = new IntArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    if (numberArray.isNull(i)) {
                        result.pushNull();
                        continue;
                    }
                    int v = numberArray.getInt(i);
                    result.push(v * v);
                }
                return result;
            }
            if (array instanceof LongArray) {
                LongArray numberArray = (LongArray)array;
                LongArray result = new LongArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    if (numberArray.isNull(i)) {
                        result.pushNull();
                        continue;
                    }
                    long v = numberArray.getLong(i);
                    result.push(v * v);
                }
                return result;
            }
            if (array instanceof DoubleArray) {
                DoubleArray numberArray = (DoubleArray)array;
                DoubleArray result = new DoubleArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    if (numberArray.isNull(i)) {
                        result.pushNull();
                        continue;
                    }
                    double v = numberArray.getDouble(i);
                    result.push(v * v);
                }
                return result;
            }
            ObjectArray result = new ObjectArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                Object obj = array.get(i);
                obj = Variant.square(obj);
                result.push(obj);
            }
            return result;
        }
        if (this.param.getSubSize() == 2) {
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("power" + mm.getMessage("function.invalidParam"));
            }
            IArray array1 = sub0.getLeafExpression().calculateAll(ctx);
            IArray array2 = sub1.getLeafExpression().calculateAll(ctx);
            int size = array1.size();
            if (array2 instanceof ConstArray) {
                Object obj2 = array2.get(1);
                if (obj2 == null) {
                    return new ConstArray(null, size);
                }
                if (!(obj2 instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("power" + mm.getMessage("function.paramTypeError"));
                }
                double d2 = ((Number)obj2).doubleValue();
                if (array1 instanceof ConstArray) {
                    Object obj1 = array1.get(1);
                    if (obj1 instanceof Number) {
                        double d1 = ((Number)obj1).doubleValue();
                        d1 = Math.pow(d1, d2);
                        return new ConstArray(new Double(d1), size);
                    }
                    if (obj1 == null) {
                        return new ConstArray(null, size);
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("power" + mm.getMessage("function.paramTypeError"));
                }
                DoubleArray result = new DoubleArray(size);
                result.setTemporary(true);
                if (array1 instanceof NumberArray) {
                    NumberArray numberArray = (NumberArray)array1;
                    for (int i = 1; i <= size; ++i) {
                        if (numberArray.isNull(i)) {
                            result.pushNull();
                            continue;
                        }
                        double v = Math.pow(numberArray.getDouble(i), d2);
                        result.push(v);
                    }
                } else {
                    for (int i = 1; i <= size; ++i) {
                        Object obj1 = array1.get(i);
                        if (obj1 instanceof Number) {
                            double v = Math.pow(((Number)obj1).doubleValue(), d2);
                            result.push(v);
                            continue;
                        }
                        if (obj1 == null) {
                            result.pushNull();
                            continue;
                        }
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("power" + mm.getMessage("function.paramTypeError"));
                    }
                }
                return result;
            }
            DoubleArray result = new DoubleArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                Object obj1 = array1.get(i);
                Object obj2 = array2.get(i);
                if (obj1 == null || obj2 == null) {
                    result.pushNull();
                    continue;
                }
                if (obj1 instanceof Number && obj2 instanceof Number) {
                    double v = Math.pow(((Number)obj1).doubleValue(), ((Number)obj2).doubleValue());
                    result.push(v);
                    continue;
                }
                MessageManager mm = EngineMessage.get();
                throw new RQException("power" + mm.getMessage("function.paramTypeError"));
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("power" + mm.getMessage("function.invalidParam"));
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        if (this.param.isLeaf()) {
            IArray array = this.param.getLeafExpression().calculateAll(ctx, signArray, sign);
            int size = array.size();
            if (array instanceof ConstArray) {
                Object obj = array.get(1);
                obj = Variant.square(obj);
                return new ConstArray(obj, size);
            }
            boolean[] signDatas = sign ? signArray.isTrue().getDatas() : signArray.isFalse().getDatas();
            if (array instanceof IntArray) {
                IntArray numberArray = (IntArray)array;
                IntArray result = new IntArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    if (!signDatas[i] || numberArray.isNull(i)) {
                        result.pushNull();
                        continue;
                    }
                    int v = numberArray.getInt(i);
                    result.push(v * v);
                }
                return result;
            }
            if (array instanceof LongArray) {
                LongArray numberArray = (LongArray)array;
                LongArray result = new LongArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    if (!signDatas[i] || numberArray.isNull(i)) {
                        result.pushNull();
                        continue;
                    }
                    long v = numberArray.getLong(i);
                    result.push(v * v);
                }
                return result;
            }
            if (array instanceof DoubleArray) {
                DoubleArray numberArray = (DoubleArray)array;
                DoubleArray result = new DoubleArray(size);
                result.setTemporary(true);
                for (int i = 1; i <= size; ++i) {
                    if (!signDatas[i] || numberArray.isNull(i)) {
                        result.pushNull();
                        continue;
                    }
                    double v = numberArray.getDouble(i);
                    result.push(v * v);
                }
                return result;
            }
            ObjectArray result = new ObjectArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Object obj = array.get(i);
                    obj = Variant.square(obj);
                    result.push(obj);
                    continue;
                }
                result.pushNull();
            }
            return result;
        }
        if (this.param.getSubSize() == 2) {
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("power" + mm.getMessage("function.invalidParam"));
            }
            IArray array1 = sub0.getLeafExpression().calculateAll(ctx);
            IArray array2 = sub1.getLeafExpression().calculateAll(ctx);
            int size = array1.size();
            boolean[] signDatas = sign ? signArray.isTrue().getDatas() : signArray.isFalse().getDatas();
            if (array2 instanceof ConstArray) {
                Object obj2 = array2.get(1);
                if (obj2 == null) {
                    return new ConstArray(null, size);
                }
                if (!(obj2 instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("power" + mm.getMessage("function.paramTypeError"));
                }
                double d2 = ((Number)obj2).doubleValue();
                if (array1 instanceof ConstArray) {
                    Object obj1 = array1.get(1);
                    if (obj1 instanceof Number) {
                        double d1 = ((Number)obj1).doubleValue();
                        d1 = Math.pow(d1, d2);
                        return new ConstArray(new Double(d1), size);
                    }
                    if (obj1 == null) {
                        return new ConstArray(null, size);
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("power" + mm.getMessage("function.paramTypeError"));
                }
                DoubleArray result = new DoubleArray(size);
                result.setTemporary(true);
                if (array1 instanceof NumberArray) {
                    NumberArray numberArray = (NumberArray)array1;
                    for (int i = 1; i <= size; ++i) {
                        if (!signDatas[i] || numberArray.isNull(i)) {
                            result.pushNull();
                            continue;
                        }
                        double v = Math.pow(numberArray.getDouble(i), d2);
                        result.push(v);
                    }
                } else {
                    for (int i = 1; i <= size; ++i) {
                        if (signDatas[i]) {
                            Object obj1 = array1.get(i);
                            if (obj1 instanceof Number) {
                                double v = Math.pow(((Number)obj1).doubleValue(), d2);
                                result.push(v);
                                continue;
                            }
                            if (obj1 == null) {
                                result.pushNull();
                                continue;
                            }
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("power" + mm.getMessage("function.paramTypeError"));
                        }
                        result.pushNull();
                    }
                }
                return result;
            }
            DoubleArray result = new DoubleArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                if (signDatas[i]) {
                    Object obj1 = array1.get(i);
                    Object obj2 = array2.get(i);
                    if (obj1 == null || obj2 == null) {
                        result.pushNull();
                        continue;
                    }
                    if (obj1 instanceof Number && obj2 instanceof Number) {
                        double v = Math.pow(((Number)obj1).doubleValue(), ((Number)obj2).doubleValue());
                        result.push(v);
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("power" + mm.getMessage("function.paramTypeError"));
                }
                result.pushNull();
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("power" + mm.getMessage("function.invalidParam"));
    }
}

