/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Round
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("round" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object o = this.param.getLeafExpression().calculate(ctx);
            return Variant.round(o);
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("round" + mm.getMessage("function.invalidParam"));
        }
        IParam p1 = this.param.getSub(0);
        IParam p2 = this.param.getSub(1);
        if (p1 == null || p2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("round" + mm.getMessage("function.invalidParam"));
        }
        Object o1 = p1.getLeafExpression().calculate(ctx);
        Object o2 = p2.getLeafExpression().calculate(ctx);
        if (o2 instanceof Number) {
            return Variant.round(o1, ((Number)o2).intValue());
        }
        if (o2 == null) {
            return Variant.round(o1);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("round" + mm.getMessage("function.paramTypeError"));
    }
}

