/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Shift
extends Function {
    private Expression _$2;
    private Expression _$1;

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("shift" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("shift" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = this.param.getSub(0);
        IParam sub2 = this.param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("shift" + mm.getMessage("function.invalidParam"));
        }
        this._$2 = sub1.getLeafExpression();
        this._$1 = sub2.getLeafExpression();
    }

    public Object calculate(Context ctx) {
        Object result1 = this._$2.calculate(ctx);
        if (result1 == null) {
            return null;
        }
        if (!(result1 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("The first param of shift" + mm.getMessage("function.paramTypeError"));
        }
        Object result2 = this._$1.calculate(ctx);
        if (result2 == null) {
            return null;
        }
        if (!(result2 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("The second param of shift" + mm.getMessage("function.paramTypeError"));
        }
        int n = ((Number)result2).intValue();
        if (n == 0) {
            return result1;
        }
        if (result1 instanceof BigDecimal) {
            BigInteger bi = ((BigDecimal)result1).toBigInteger();
            bi = n > 0 ? bi.shiftRight(n) : bi.shiftLeft(-n);
            return new BigDecimal(bi);
        }
        if (result1 instanceof BigInteger) {
            BigInteger bi = (BigInteger)result1;
            bi = n > 0 ? bi.shiftRight(n) : bi.shiftLeft(-n);
            return new BigDecimal(bi);
        }
        if (result1 instanceof Integer) {
            int x = ((Number)result1).intValue();
            if (n > 0) {
                if (this.option == null || this.option.indexOf(115) == -1) {
                    return x >>> n;
                }
                return x >> n;
            }
            return x << -n;
        }
        long x = ((Number)result1).longValue();
        if (n > 0) {
            if (this.option == null || this.option.indexOf(115) == -1) {
                return x >>> n;
            }
            return x >> n;
        }
        return x << -n;
    }
}

